/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.blocks;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.nms.util.jnbt.ByteArrayTag;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizen.nms.util.jnbt.IntTag;
import net.aufdemrand.denizen.nms.util.jnbt.ListTag;
import net.aufdemrand.denizen.nms.util.jnbt.NBTInputStream;
import net.aufdemrand.denizen.nms.util.jnbt.NBTOutputStream;
import net.aufdemrand.denizen.nms.util.jnbt.NamedTag;
import net.aufdemrand.denizen.nms.util.jnbt.ShortTag;
import net.aufdemrand.denizen.nms.util.jnbt.StringTag;
import net.aufdemrand.denizen.nms.util.jnbt.Tag;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.scripts.commands.world.SchematicCommand;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.blocks.BlockSet;
import net.aufdemrand.denizen.utilities.blocks.OldMaterialsHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class CuboidBlockSet
implements BlockSet {
    public List<BlockData> blocks = new ArrayList<BlockData>();
    public double x_width;
    public double y_length;
    public double z_height;
    public double center_x;
    public double center_y;
    public double center_z;

    public CuboidBlockSet() {
    }

    public CuboidBlockSet(dCuboid cuboid, Location center) {
        dLocation low = cuboid.pairs.get((int)0).low;
        dLocation high = cuboid.pairs.get((int)0).high;
        this.x_width = high.getX() - low.getX() + 1.0;
        this.y_length = high.getY() - low.getY() + 1.0;
        this.z_height = high.getZ() - low.getZ() + 1.0;
        this.center_x = center.getX() - low.getX();
        this.center_y = center.getY() - low.getY();
        this.center_z = center.getZ() - low.getZ();
        int x = 0;
        while ((double)x < this.x_width) {
            int y = 0;
            while ((double)y < this.y_length) {
                int z = 0;
                while ((double)z < this.z_height) {
                    this.blocks.add(NMSHandler.getInstance().getBlockHelper().getBlockData(low.clone().add((double)x, (double)y, (double)z).getBlock()));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public List<BlockData> getBlocks() {
        return this.blocks;
    }

    public dCuboid getCuboid(Location loc) {
        Location low = loc.clone().subtract(this.center_x, this.center_y, this.center_z);
        Location high = low.clone().add(this.x_width, this.y_length, this.z_height);
        return new dCuboid(low, high);
    }

    @Override
    public void setBlocksDelayed(final Location loc, final Runnable runme, final boolean noAir) {
        final IntHolder index = new IntHolder();
        final long goal = (long)(this.x_width * this.y_length * this.z_height);
        new BukkitRunnable(){

            public void run() {
                SchematicCommand.noPhys = true;
                long start = System.currentTimeMillis();
                while (index.theInt < goal) {
                    long z = index.theInt % (long)CuboidBlockSet.this.z_height;
                    long y = (index.theInt - z) % (long)(CuboidBlockSet.this.y_length * CuboidBlockSet.this.z_height) / (long)CuboidBlockSet.this.z_height;
                    long x = (index.theInt - y - z) / (long)(CuboidBlockSet.this.y_length * CuboidBlockSet.this.z_height);
                    if (!noAir || CuboidBlockSet.this.blocks.get((int)index.theInt).getMaterial() != Material.AIR) {
                        CuboidBlockSet.this.blocks.get((int)index.theInt).setBlock(loc.clone().add((double)x - CuboidBlockSet.this.center_x, (double)y - CuboidBlockSet.this.center_y, (double)z - CuboidBlockSet.this.center_z).getBlock(), false);
                    }
                    ++index.theInt;
                    if (System.currentTimeMillis() - start <= 50L) continue;
                    SchematicCommand.noPhys = false;
                    return;
                }
                SchematicCommand.noPhys = false;
                if (runme != null) {
                    runme.run();
                }
                this.cancel();
            }
        }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 1L, 1L);
    }

    @Override
    public void setBlocks(Location loc, boolean noAir) {
        SchematicCommand.noPhys = true;
        int index = 0;
        int x = 0;
        while ((double)x < this.x_width) {
            int y = 0;
            while ((double)y < this.y_length) {
                int z = 0;
                while ((double)z < this.z_height) {
                    if (!noAir || this.blocks.get(index).getMaterial() != Material.AIR) {
                        this.blocks.get(index).setBlock(loc.clone().add((double)x - this.center_x, (double)y - this.center_y, (double)z - this.center_z).getBlock(), false);
                    }
                    ++index;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        SchematicCommand.noPhys = false;
    }

    public void rotateOne() {
        ArrayList<BlockData> bd = new ArrayList<BlockData>();
        double cx = this.center_x;
        this.center_x = this.center_z;
        this.center_z = cx;
        int x = 0;
        while ((double)x < this.z_height) {
            int y = 0;
            while ((double)y < this.y_length) {
                for (int z = (int)this.x_width - 1; z >= 0; --z) {
                    bd.add(this.blockAt(z, y, x));
                }
                ++y;
            }
            ++x;
        }
        double xw = this.x_width;
        this.x_width = this.z_height;
        this.z_height = xw;
        this.blocks = bd;
    }

    public void flipX() {
        ArrayList<BlockData> bd = new ArrayList<BlockData>();
        this.center_x = this.x_width - this.center_x;
        for (int x = (int)this.x_width - 1; x >= 0; --x) {
            int y = 0;
            while ((double)y < this.y_length) {
                int z = 0;
                while ((double)z < this.z_height) {
                    bd.add(this.blockAt(x, y, z));
                    ++z;
                }
                ++y;
            }
        }
        this.blocks = bd;
    }

    public void flipY() {
        ArrayList<BlockData> bd = new ArrayList<BlockData>();
        this.center_x = this.x_width - this.center_x;
        int x = 0;
        while ((double)x < this.x_width) {
            for (int y = (int)this.y_length - 1; y >= 0; --y) {
                int z = 0;
                while ((double)z < this.z_height) {
                    bd.add(this.blockAt(x, y, z));
                    ++z;
                }
            }
            ++x;
        }
        this.blocks = bd;
    }

    public void flipZ() {
        ArrayList<BlockData> bd = new ArrayList<BlockData>();
        this.center_x = this.x_width - this.center_x;
        int x = 0;
        while ((double)x < this.x_width) {
            int y = 0;
            while ((double)y < this.y_length) {
                for (int z = (int)this.z_height - 1; z >= 0; --z) {
                    bd.add(this.blockAt(x, y, z));
                }
                ++y;
            }
            ++x;
        }
        this.blocks = bd;
    }

    public BlockData blockAt(double X, double Y, double Z) {
        return this.blocks.get((int)(Z + Y * this.z_height + X * this.z_height * this.y_length));
    }

    public static CuboidBlockSet fromMCEditStream(InputStream is) {
        CuboidBlockSet cbs = new CuboidBlockSet();
        try {
            NBTInputStream nbtStream = new NBTInputStream(new GZIPInputStream(is));
            NamedTag rootTag = nbtStream.readNamedTag();
            nbtStream.close();
            if (!rootTag.getName().equals("Schematic")) {
                throw new Exception("Tag 'Schematic' does not exist or is not first!");
            }
            CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
            Object schematic = schematicTag.getValue();
            int width = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue().shortValue();
            int length = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue().shortValue();
            int height = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue().shortValue();
            int originX = 0;
            int originY = 0;
            int originZ = 0;
            try {
                originX = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "DenizenOriginX", IntTag.class).getValue();
                originY = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "DenizenOriginY", IntTag.class).getValue();
                originZ = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "DenizenOriginZ", IntTag.class).getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            cbs.x_width = width;
            cbs.z_height = length;
            cbs.y_length = height;
            cbs.center_x = originX;
            cbs.center_y = originY;
            cbs.center_z = originZ;
            String materials = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Materials", StringTag.class).getValue();
            if (!materials.equals("Alpha")) {
                throw new Exception("Schematic file is not an Alpha schematic!");
            }
            byte[] blockId = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
            byte[] blockData = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
            byte[] addId = new byte[]{};
            short[] blocks = new short[blockId.length];
            if (schematic.containsKey("AddBlocks")) {
                addId = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "AddBlocks", ByteArrayTag.class).getValue();
            }
            for (int index = 0; index < blockId.length; ++index) {
                blocks[index] = index >> 1 >= addId.length ? (short)(blockId[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blockId[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blockId[index] & 0xFF)));
            }
            Object tileEntities = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class).getValue();
            HashMap tileEntitiesMap = new HashMap();
            Iterator iterator = tileEntities.iterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag t = (CompoundTag)tag;
                int x = 0;
                int y = 0;
                int z = 0;
                HashMap values = new HashMap();
                for (Map.Entry entry : t.getValue().entrySet()) {
                    if (((String)entry.getKey()).equals("x")) {
                        if (entry.getValue() instanceof IntTag) {
                            x = ((IntTag)entry.getValue()).getValue();
                        }
                    } else if (((String)entry.getKey()).equals("y")) {
                        if (entry.getValue() instanceof IntTag) {
                            y = ((IntTag)entry.getValue()).getValue();
                        }
                    } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                        z = ((IntTag)entry.getValue()).getValue();
                    }
                    values.put(entry.getKey(), entry.getValue());
                }
                BlockVector vec = new BlockVector(x, y, z);
                tileEntitiesMap.put(vec, values);
            }
            Vector vec = new Vector(width, height, length);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < length; ++z) {
                        int index = y * width * length + z * width + x;
                        BlockVector pt = new BlockVector(x, y, z);
                        dMaterial dMat = OldMaterialsHelper.getMaterialFrom(OldMaterialsHelper.getLegacyMaterial(blocks[index]), blockData[index]);
                        BlockData block = dMat.getNmsBlockData();
                        if (tileEntitiesMap.containsKey(pt)) {
                            CompoundTag otag = NMSHandler.getInstance().createCompoundTag((Map)tileEntitiesMap.get(pt));
                            block.setCompoundTag(otag);
                        }
                        cbs.blocks.add(block);
                    }
                }
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return cbs;
    }

    private static <T extends Tag> T getChildTag(Map<String, Tag> items, String key, Class<T> expected) throws Exception {
        if (!items.containsKey(key)) {
            throw new Exception("Schematic file is missing a '" + key + "' tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new Exception(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((Tag)expected.cast(tag));
    }

    public void saveMCEditFormatToStream(OutputStream os) {
        try {
            HashMap<String, Tag> schematic = new HashMap<String, Tag>();
            schematic.put("Width", new ShortTag((short)this.x_width));
            schematic.put("Length", new ShortTag((short)this.z_height));
            schematic.put("Height", new ShortTag((short)this.y_length));
            schematic.put("Materials", new StringTag("Alpha"));
            schematic.put("DenizenOriginX", new IntTag((int)this.center_x));
            schematic.put("DenizenOriginY", new IntTag((int)this.center_y));
            schematic.put("DenizenOriginZ", new IntTag((int)this.center_z));
            schematic.put("WEOriginX", new IntTag((int)this.center_x));
            schematic.put("WEOriginY", new IntTag((int)this.center_y));
            schematic.put("WEOriginZ", new IntTag((int)this.center_z));
            schematic.put("WEOffsetX", new IntTag(0));
            schematic.put("WEOffsetY", new IntTag(0));
            schematic.put("WEOffsetZ", new IntTag(0));
            byte[] blocks = new byte[(int)(this.x_width * this.y_length * this.z_height)];
            byte[] addBlocks = null;
            byte[] blockData = new byte[blocks.length];
            ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
            int indexer = 0;
            int x = 0;
            while ((double)x < this.x_width) {
                int y = 0;
                while ((double)y < this.y_length) {
                    int z = 0;
                    while ((double)z < this.z_height) {
                        int index = (int)((double)y * this.x_width * this.z_height + (double)z * this.x_width + (double)x);
                        BlockData bd = this.blocks.get(indexer);
                        ++indexer;
                        int matId = NMSHandler.getInstance().getBlockHelper().idFor(bd.getMaterial());
                        if (matId > 255) {
                            if (addBlocks == null) {
                                addBlocks = new byte[(blocks.length >> 1) + 1];
                            }
                            addBlocks[index >> 1] = (byte)((index & 1) == 0 ? addBlocks[index >> 1] & 0xF0 | matId >> 8 & 0xF : addBlocks[index >> 1] & 0xF | (matId >> 8 & 0xF) << 4);
                        }
                        blocks[index] = (byte)matId;
                        blockData[index] = bd.getData();
                        CompoundTag rawTag = bd.getCompoundTag();
                        if (rawTag != null) {
                            HashMap<String, Tag> values = new HashMap<String, Tag>();
                            for (Map.Entry entry : rawTag.getValue().entrySet()) {
                                values.put((String)entry.getKey(), (Tag)entry.getValue());
                            }
                            values.put("x", new IntTag(x));
                            values.put("y", new IntTag(y));
                            values.put("z", new IntTag(z));
                            CompoundTag tileEntityTag = NMSHandler.getInstance().createCompoundTag(values);
                            tileEntities.add(tileEntityTag);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            schematic.put("Blocks", new ByteArrayTag(blocks));
            schematic.put("Data", new ByteArrayTag(blockData));
            schematic.put("Entities", new ListTag(CompoundTag.class, new ArrayList()));
            schematic.put("TileEntities", new ListTag(CompoundTag.class, tileEntities));
            if (addBlocks != null) {
                schematic.put("AddBlocks", new ByteArrayTag(addBlocks));
            }
            CompoundTag schematicTag = NMSHandler.getInstance().createCompoundTag(schematic);
            NBTOutputStream stream = new NBTOutputStream(new GZIPOutputStream(os));
            stream.writeNamedTag("Schematic", schematicTag);
            os.flush();
            stream.close();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public class IntHolder {
        public long theInt = 0L;
    }
}

