/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.core.ConsoleOutputScriptEvent;
import net.aufdemrand.denizencore.events.core.DeltaTimeScriptEvent;
import net.aufdemrand.denizencore.events.core.ReloadScriptsScriptEvent;
import net.aufdemrand.denizencore.events.core.SystemTimeScriptEvent;
import net.aufdemrand.denizencore.events.core.TickScriptEvent;
import net.aufdemrand.denizencore.interfaces.ContextSource;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.ScriptEntrySet;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.scheduling.OneTimeSchedulable;
import net.aufdemrand.denizencore.utilities.text.StringHolder;

public abstract class ScriptEvent
implements ContextSource,
Cloneable {
    public static ArrayList<ScriptContainer> worldContainers = new ArrayList();
    public static ArrayList<ScriptEvent> events = new ArrayList();
    public static HashMap<String, ScriptEvent> eventLookup = new HashMap();
    public StatData stats = new StatData();
    public ArrayList<ScriptPath> eventPaths = new ArrayList();
    public boolean cancelled = false;
    public static HashSet<String> defaultDeterminations = new HashSet<String>(Arrays.asList("cancelled", "cancelled:true", "cancelled:false"));
    Runnable resetRunnable = new Runnable(){

        @Override
        public void run() {
            ScriptEvent.this.reset();
        }
    };
    private String currentEvent;
    public static final HashMap<String, Pattern> knownPatterns = new HashMap();

    public ScriptEvent clone() {
        try {
            return (ScriptEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            dB.echoError("Clone not supported for script events?!");
            return this;
        }
    }

    public static void registerCoreEvents() {
        ScriptEvent.registerScriptEvent(new ConsoleOutputScriptEvent());
        ScriptEvent.registerScriptEvent(new DeltaTimeScriptEvent());
        ScriptEvent.registerScriptEvent(new ReloadScriptsScriptEvent());
        ScriptEvent.registerScriptEvent(new SystemTimeScriptEvent());
        ScriptEvent.registerScriptEvent(new TickScriptEvent());
    }

    public static void registerScriptEvent(ScriptEvent event) {
        event.reset();
        events.add(event);
        eventLookup.put(CoreUtilities.toLowerCase(event.getName()), event);
    }

    public static void reload() {
        dB.log("Reloading script events...");
        for (ScriptContainer container : worldContainers) {
            if (!container.getContents().getString("enabled", "true").equalsIgnoreCase("true")) continue;
            YamlConfiguration config = container.getConfigurationSection("events");
            if (config == null) {
                dB.echoError("Missing or invalid events block for " + container.getName());
                continue;
            }
            for (StringHolder evt : config.getKeys(false)) {
                if (evt == null || evt.str == null) {
                    dB.echoError("Missing or invalid events block for " + container.getName());
                    continue;
                }
                if (!evt.str.contains("@")) continue;
                dB.echoError("Script '" + container.getName() + "' has event '" + evt.str.replace("@", "<R>@<W>") + "' which contains object notation, which is deprecated for use in world events. Please remove it.");
            }
        }
        for (ScriptEvent event : events) {
            try {
                event.destroy();
                event.eventPaths.clear();
                boolean matched = false;
                for (ScriptContainer container : worldContainers) {
                    YamlConfiguration config = container.getConfigurationSection("events");
                    if (config == null) continue;
                    for (StringHolder evt1 : config.getKeys(false)) {
                        String evt = evt1.str.substring(3);
                        if (!ScriptEvent.couldMatchScript(event, container, evt)) continue;
                        event.eventPaths.add(new ScriptPath(container, evt));
                        dB.log("Event match, " + event.getName() + " matched for '" + evt + "'!");
                        matched = true;
                    }
                }
                if (!matched) continue;
                event.sort();
                event.init();
            }
            catch (Throwable ex) {
                dB.echoError("Failed to reload event '" + event.getName() + "':");
                dB.echoError(ex);
            }
        }
    }

    public static boolean matchesScript(ScriptEvent sEvent, ScriptPath path) {
        if (path.switch_cancelled != null ? path.switch_cancelled != sEvent.cancelled : (path.switch_ignoreCancelled != null ? path.switch_ignoreCancelled == false && sEvent.cancelled : sEvent.cancelled)) {
            return false;
        }
        return sEvent.matches(path);
    }

    public static boolean couldMatchScript(ScriptEvent sEvent, ScriptContainer script, String event) {
        return sEvent.couldMatch(script, event);
    }

    public void sort() {
        for (ScriptPath path : this.eventPaths) {
            String gotten = path.switches.get("priority");
            path.priority = gotten == null ? 0 : aH.getIntegerFrom(gotten);
        }
        Collections.sort(this.eventPaths, new Comparator<ScriptPath>(){

            @Override
            public int compare(ScriptPath scriptPath, ScriptPath t1) {
                int rel = scriptPath.priority - t1.priority;
                return rel < 0 ? -1 : (rel > 0 ? 1 : 0);
            }
        });
    }

    public void init() {
    }

    public void destroy() {
    }

    @Deprecated
    public static boolean checkSwitch(String event, String switcher, String value) {
        for (String possible : CoreUtilities.split(event, ' ')) {
            List<String> split = CoreUtilities.split(possible, ':', 2);
            if (!split.get(0).equalsIgnoreCase(switcher) || split.size() <= 1 || split.get(1).equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String getSwitch(String event, String switcher) {
        for (String possible : CoreUtilities.split(event, ' ')) {
            List<String> split = CoreUtilities.split(possible, ':', 2);
            if (!split.get(0).equalsIgnoreCase(switcher) || split.size() <= 1) continue;
            return split.get(1);
        }
        return null;
    }

    public boolean applyDetermination(ScriptContainer container, dObject determination) {
        return this.applyDetermination(container, determination.identify());
    }

    public static boolean isDefaultDetermination(String determination) {
        String low = CoreUtilities.toLowerCase(determination);
        return defaultDeterminations.contains(low);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        String low = CoreUtilities.toLowerCase(determination);
        if (low.equals("cancelled")) {
            dB.echoDebug((Debuggable)container, "Event cancelled!");
            this.cancelled = true;
            return true;
        }
        if (low.equals("cancelled:true")) {
            dB.echoDebug((Debuggable)container, "Event cancelled!");
            this.cancelled = true;
            return true;
        }
        if (low.equals("cancelled:false")) {
            dB.echoDebug((Debuggable)container, "Event uncancelled!");
            this.cancelled = false;
            return true;
        }
        dB.echoError("Unknown determination '" + determination + "'");
        return false;
    }

    public HashMap<String, dObject> getContext() {
        return new HashMap<String, dObject>();
    }

    public ScriptEntryData getScriptEntryData() {
        return DenizenCore.getImplementation().getEmptyScriptEntryData();
    }

    public abstract boolean couldMatch(ScriptContainer var1, String var2);

    public boolean matches(ScriptPath path) {
        return this.matches(path.container, path.event);
    }

    public boolean matches(ScriptContainer script, String event) {
        throw new UnsupportedOperationException("Matches not implemented for event '" + this.getName() + "'! Report this error to the Denizen developers!");
    }

    public abstract String getName();

    public void reset() {
        this.cancelled = false;
    }

    public void fire() {
        ++this.stats.fires;
        for (ScriptPath path : this.eventPaths) {
            try {
                if (!ScriptEvent.matchesScript(this, path)) continue;
                this.run(path);
            }
            catch (Exception e) {
                dB.echoError("Handling script " + path.container.getName() + " path:" + path.event + ":::");
                dB.echoError(e);
            }
        }
        if (this.cancelled) {
            DenizenCore.schedule(new OneTimeSchedulable(this.resetRunnable, 0.01f));
        }
    }

    public void run(ScriptPath path) {
        ++this.stats.scriptFires;
        HashMap<String, dObject> context = this.getContext();
        if (path.container.shouldDebug()) {
            dB.echoDebug((Debuggable)path.container, "<Y>Running script event '<A>" + this.getName() + "<Y>', event='<A>" + path.event + "<Y>' for script '<A>" + path.container.getName() + "<Y>'");
            for (Map.Entry<String, dObject> obj : context.entrySet()) {
                dB.echoDebug((Debuggable)path.container, "<Y>Context '<A>" + obj.getKey() + "<Y>' = '<A>" + obj.getValue().identify() + "<Y>'");
            }
        }
        if (path.set == null) {
            path.set = path.container.getSetFor("events.on " + path.event);
        }
        List<ScriptEntry> entries = ScriptContainer.cleanDup(this.getScriptEntryData(), path.set);
        ScriptQueue queue = new InstantQueue(path.container.getName()).addEntries(entries);
        HashMap<String, dObject> oldStyleContext = this.getContext();
        this.currentEvent = path.event;
        if (oldStyleContext.size() > 0) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = oldStyleContext;
            oecs.contexts.put("cancelled", new Element(this.cancelled));
            oecs.contexts.put("event_header", new Element(this.currentEvent));
            queue.setContextSource(oecs);
        } else {
            queue.setContextSource(this.clone());
        }
        queue.start();
        this.stats.nanoTimes += System.nanoTime() - queue.startTime;
        dList outList = queue.determinations;
        if (outList != null && !outList.isEmpty()) {
            ArrayList<dObject> determinations = outList.objectForms;
            for (dObject determination : determinations) {
                this.applyDetermination(path.container, determination);
            }
        }
    }

    @Override
    public boolean getShouldCache() {
        return false;
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("cancelled")) {
            return new Element(this.cancelled);
        }
        if (name.equals("event_header")) {
            return new Element(this.currentEvent);
        }
        if (name.equals("event_name")) {
            return new Element(this.getName());
        }
        return null;
    }

    public static String quotify(String input) {
        StringBuilder output = new StringBuilder(input.length());
        int last = 0;
        int index = input.indexOf(42);
        while (index >= 0) {
            output.append(Pattern.quote(input.substring(last, index))).append("(.*)");
            last = index + 1;
            index = input.indexOf(42, last);
        }
        output.append(Pattern.quote(input.substring(last)));
        return output.toString();
    }

    public static Pattern regexHandle(String input) {
        String output;
        Pattern result = knownPatterns.get(input);
        if (result != null) {
            return result;
        }
        if (input.startsWith("regex:")) {
            output = input.substring("regex:".length());
        } else if (input.contains("|")) {
            CharSequence[] split = input.split("\\|");
            for (int i = 0; i < split.length; ++i) {
                split[i] = ScriptEvent.quotify((String)split[i]);
            }
            output = String.join((CharSequence)"|", split);
        } else if (input.contains("*")) {
            output = ScriptEvent.quotify(input);
        } else {
            return null;
        }
        if (dB.verbose) {
            dB.log("Event regex compile: " + output);
        }
        result = Pattern.compile(output);
        knownPatterns.put(input, result);
        return result;
    }

    public static boolean equalityCheck(String input, String compared, Pattern regexed) {
        return (input = CoreUtilities.toLowerCase(input)).equals(compared) || regexed != null && regexed.matcher(input).matches();
    }

    public static class ScriptPath {
        public ScriptContainer container;
        public String event;
        public String eventLower;
        public int priority = 0;
        public ScriptEntrySet set;
        public Boolean switch_cancelled;
        public Boolean switch_ignoreCancelled;
        public HashMap<String, String> switches = new HashMap();
        public String[] eventArgs;
        public String[] eventArgsLower;
        public String[] rawEventArgs;

        public String rawEventArgAt(int index) {
            return index < this.rawEventArgs.length ? this.rawEventArgs[index] : "";
        }

        public String eventArgAt(int index) {
            return index < this.eventArgs.length ? this.eventArgs[index] : "";
        }

        public String eventArgLowerAt(int index) {
            return index < this.eventArgsLower.length ? this.eventArgsLower[index] : "";
        }

        public boolean checkSwitch(String key, String value) {
            String pathValue = this.switches.get(key);
            if (pathValue == null) {
                return true;
            }
            return CoreUtilities.toLowerCase(pathValue).equals(value);
        }

        public ScriptPath(ScriptContainer container, String event) {
            this.event = event;
            this.rawEventArgs = CoreUtilities.split(event, ' ').toArray(new String[0]);
            this.container = container;
            ArrayList<String> eventLabel = new ArrayList<String>();
            for (String possible : CoreUtilities.split(event, ' ').toArray(new String[0])) {
                List<String> split = CoreUtilities.split(possible, ':', 2);
                if (split.size() > 1) {
                    this.switches.put(CoreUtilities.toLowerCase(split.get(0)), split.get(1));
                    continue;
                }
                eventLabel.add(possible);
            }
            this.eventLower = CoreUtilities.toLowerCase(String.join((CharSequence)" ", eventLabel));
            this.eventArgs = eventLabel.toArray(new String[0]);
            this.eventArgsLower = CoreUtilities.split(this.eventLower, ' ').toArray(new String[0]);
            this.switch_cancelled = this.switches.containsKey("cancelled") ? Boolean.valueOf(this.switches.get("cancelled").equalsIgnoreCase("true")) : null;
            this.switch_ignoreCancelled = this.switches.containsKey("ignorecancelled") ? Boolean.valueOf(this.switches.get("ignorecancelled").equalsIgnoreCase("true")) : null;
        }
    }

    public static class StatData {
        public long fires = 0L;
        public long scriptFires = 0L;
        public long nanoTimes = 0L;
    }
}

