/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.events.core;

import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;

public class DeltaTimeScriptEvent
extends ScriptEvent {
    public static DeltaTimeScriptEvent instance;
    public ScriptEntryData data = null;
    public Element second;
    boolean enabled = false;

    public DeltaTimeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer script, String event) {
        return event.startsWith("delta time");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        int count;
        String time = path.rawEventArgAt(2);
        long seconds = DenizenCore.serverTimeMillis / 1000L;
        String countString = path.switches.get("every");
        int n = count = countString == null ? 1 : aH.getIntegerFrom(countString);
        if (time.equals("secondly")) {
            return seconds % (long)count == 0L;
        }
        if (time.equals("minutely")) {
            if (seconds % 60L != 0L) {
                return false;
            }
            long minutes = seconds / 60L;
            return minutes % (long)count == 0L;
        }
        if (time.equals("hourly")) {
            if (seconds % 3600L != 0L) {
                return false;
            }
            long hours = seconds / 3600L;
            return hours % (long)count == 0L;
        }
        return false;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return this.data;
    }

    @Override
    public String getName() {
        return "DeltaTime";
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("second")) {
            return this.second;
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        this.enabled = true;
    }

    @Override
    public void destroy() {
        this.enabled = false;
    }

    public void checkTime() {
        if (!this.enabled) {
            return;
        }
        this.second = new Element(DenizenCore.serverTimeMillis / 1000L);
        this.data = DenizenCore.getImplementation().getEmptyScriptEntryData();
        this.fire();
    }
}

