/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.util.Map;
import java.util.regex.Matcher;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.core.CustomScriptContainer;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class CustomObject
implements dObject,
dObject.ObjectAttributable,
Adjustable {
    public CustomScriptContainer container;
    public Map<String, dObject> vars;
    private String prefix = "Custom";

    @Fetchable(value="custom")
    public static CustomObject valueOf(String string, TagContext context) {
        String typeData;
        Object sc;
        Matcher m = ObjectFetcher.DESCRIBED_PATTERN.matcher(string);
        if (m.matches()) {
            return ObjectFetcher.getObjectFrom(CustomObject.class, string, context);
        }
        if (string.startsWith("custom@")) {
            string = string.substring("custom@".length());
        }
        if ((sc = ScriptRegistry.getScriptContainer(typeData = string)) == null) {
            if (context == null || context.debug) {
                dB.echoError("Null script container for " + typeData);
            }
            return null;
        }
        if (!(sc instanceof CustomScriptContainer)) {
            if (context == null || context.debug) {
                dB.echoError("Wrong-typed script container for " + typeData);
            }
            return null;
        }
        return new CustomObject((CustomScriptContainer)sc, ((CustomScriptContainer)sc).getVars());
    }

    public static CustomObject getFor(dObject obj, TagContext context) {
        return obj instanceof CustomObject ? (CustomObject)obj : CustomObject.valueOf(obj.toString(), context);
    }

    public static boolean matches(String string) {
        return string.startsWith("custom@");
    }

    public CustomObject(CustomScriptContainer type, Map<String, dObject> values) {
        this.container = type;
        this.vars = values;
    }

    @Override
    public String getObjectType() {
        return "Custom";
    }

    @Override
    public String identify() {
        StringBuilder outp = new StringBuilder();
        for (Map.Entry<String, dObject> var : this.vars.entrySet()) {
            outp.append(var.getKey() + "=" + var.getValue().toString().replace(';', '\u2011') + ";");
        }
        return "custom@" + this.container.getName() + "[" + (outp.length() > 0 ? outp.substring(0, outp.length() - 1) : "") + "]";
    }

    @Override
    public String identifySimple() {
        return "custom@" + this.container.getName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        return CoreUtilities.stringifyNullPass(this.getObjectAttribute(attribute));
    }

    @Override
    public <T extends dObject> T asObjectType(Class<T> type, TagContext context) {
        return null;
    }

    @Override
    public dObject getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.isComplete()) {
            return this;
        }
        dObject res = this.vars.get(attribute.getAttribute(1));
        if (res == null) {
            String taggo = attribute.getAttributeWithoutContext(1);
            if (this.container.hasPath("tags." + taggo)) {
                dList outcomes = this.container.runTagScript(taggo, attribute.getContextObject(1), this, attribute.getScriptEntry() != null ? attribute.getScriptEntry().entryData : DenizenCore.getImplementation().getEmptyScriptEntryData());
                if (outcomes == null) {
                    return null;
                }
                return CoreUtilities.autoAttribTyped(outcomes.getObject(0), attribute.fulfill(1));
            }
            return new Element(this.identify()).getObjectAttribute(attribute);
        }
        return CoreUtilities.autoAttribTyped(res, attribute.fulfill(1));
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String name = CoreUtilities.toLowerCase(mechanism.getName());
        if (!mechanism.hasValue()) {
            this.vars.remove(name);
            return;
        }
        Element value = mechanism.getValue();
        if (this.container.hasPath("mechanisms." + name)) {
            dList outcomes = this.container.runMechScript(name, this, value);
            if (outcomes == null) {
                return;
            }
            CustomObject co = CustomObject.getFor(outcomes.getObject(0), null);
            this.container = co.container;
            this.vars = co.vars;
        } else {
            this.vars.put(name, value);
        }
        mechanism.fulfill();
    }
}

