/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ScriptBuilder {
    public static List<ScriptEntry> addObjectToEntries(List<ScriptEntry> scriptEntryList, String key, Object obj) {
        for (ScriptEntry entry : scriptEntryList) {
            entry.addObject(key, obj);
            entry.trackObject(key);
        }
        return scriptEntryList;
    }

    public static List<ScriptEntry> buildScriptEntries(List<Object> contents, ScriptContainer parent, ScriptEntryData data) {
        ArrayList<ScriptEntry> scriptCommands = new ArrayList<ScriptEntry>();
        if (contents == null || contents.isEmpty()) {
            if (dB.showScriptBuilder) {
                dB.echoError("Building script entries... no entries to build!");
            }
            return null;
        }
        if (dB.showScriptBuilder) {
            dB.echoDebug((Debuggable)parent, "Building script entries:");
        }
        for (Object ientry : contents) {
            List inside;
            String entry;
            if (ientry == null) {
                ientry = "null";
            }
            if (ientry instanceof Map) {
                Object key = ((Map)ientry).keySet().toArray()[0];
                entry = key.toString();
                inside = (List)((Map)ientry).get(key);
            } else {
                entry = ientry.toString();
                inside = null;
            }
            String[] splitEntry = entry.split(" ", 2);
            String[] scriptEntry = splitEntry.length == 1 ? new String[]{entry, null} : splitEntry;
            try {
                Object[] args = aH.buildArgs(scriptEntry[1]);
                if (dB.showScriptBuilder) {
                    dB.echoDebug((Debuggable)parent, "Adding '" + scriptEntry[0] + "'  Args: " + Arrays.toString(args));
                }
                ScriptEntry newEntry = new ScriptEntry(scriptEntry[0], (String[])args, parent, inside);
                newEntry.internal.originalLine = entry;
                newEntry.entryData.transferDataFrom(data);
                scriptCommands.add(newEntry);
            }
            catch (Exception e) {
                dB.echoError(e);
            }
        }
        return scriptCommands;
    }
}

