/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizencore.interfaces.RegistrationableInstance;
import net.aufdemrand.denizencore.interfaces.dRegistry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.core.AdjustCommand;
import net.aufdemrand.denizencore.scripts.commands.core.DebugCommand;
import net.aufdemrand.denizencore.scripts.commands.core.EventCommand;
import net.aufdemrand.denizencore.scripts.commands.core.ReloadCommand;
import net.aufdemrand.denizencore.scripts.commands.core.SQLCommand;
import net.aufdemrand.denizencore.scripts.commands.core.WebGetCommand;
import net.aufdemrand.denizencore.scripts.commands.file.FileCopyCommand;
import net.aufdemrand.denizencore.scripts.commands.file.LogCommand;
import net.aufdemrand.denizencore.scripts.commands.file.YamlCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.AsyncCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.ChooseCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.DefineCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.DetermineCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.ElseCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.ForeachCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.GotoCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.IfCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.InjectCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.MarkCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.QueueCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.RandomCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.RepeatCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.RunCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.StopCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.SyncCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.WaitCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.WaitUntilCommand;
import net.aufdemrand.denizencore.scripts.commands.queue.WhileCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public abstract class CommandRegistry
implements dRegistry {
    public final Map<String, AbstractCommand> instances = new HashMap<String, AbstractCommand>();
    public final Map<Class<? extends AbstractCommand>, String> classes = new HashMap<Class<? extends AbstractCommand>, String>();

    @Override
    public boolean register(String commandName, RegistrationableInstance commandInstance) {
        this.instances.put(CoreUtilities.toLowerCase(commandName), (AbstractCommand)commandInstance);
        this.classes.put(((AbstractCommand)commandInstance).getClass(), CoreUtilities.toLowerCase(commandName));
        return true;
    }

    public Map<String, AbstractCommand> list() {
        return this.instances;
    }

    @Override
    public AbstractCommand get(String commandName) {
        return this.instances.get(CoreUtilities.toLowerCase(commandName));
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        String command = this.classes.get(clazz);
        if (command != null) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(command)));
        }
        return null;
    }

    public void registerCoreCommands() {
        this.registerCoreMember(AdjustCommand.class, "ADJUST", "adjust [<dObject>/def:<name>|...] [<mechanism>](:<value>)", 2);
        this.registerCoreMember(AsyncCommand.class, "ASYNC", "async [<commands>]", 0);
        this.registerCoreMember(ChooseCommand.class, "CHOOSE", "choose [<option>] [<cases>]", 1);
        this.registerCoreMember(DebugCommand.class, "DEBUG", "debug [<type>] [<message>] (name:<name>)", 2);
        this.registerCoreMember(DefineCommand.class, "DEFINE", "define [<id>] [<value>]", 1);
        this.registerCoreMember(DetermineCommand.class, "DETERMINE", "determine (passively) [<value>]", 1);
        this.registerCoreMember(ElseCommand.class, "ELSE", "else (if <comparison logic>)", 0);
        this.registerCoreMember(EventCommand.class, "EVENT", "event [<event name>|...] (context:<name>|<object>|...)", 1);
        this.registerCoreMember(FileCopyCommand.class, "FILECOPY", "filecopy [origin:<origin>] [destination:<destination>] (overwrite)", 2);
        this.registerCoreMember(ForeachCommand.class, "FOREACH", "foreach [stop/next/<object>|...] (as:<name>) [<commands>]", 1);
        this.registerCoreMember(GotoCommand.class, "GOTO", "goto [<name>]", 1);
        this.registerCoreMember(IfCommand.class, "IF", "if [<value>] (!)(<operator> <value>) (&&/|| ...) [<commands>] (else <commands>)", 1);
        this.registerCoreMember(InjectCommand.class, "INJECT", "inject (locally) [<script>] (path:<name>) (instantly)", 1);
        this.registerCoreMember(LogCommand.class, "LOG", "log [<text>] (type:{info}/severe/warning/fine/finer/finest/none/clear) [file:<name>]", 2);
        this.registerCoreMember(MarkCommand.class, "MARK", "mark [<name>]", 1);
        this.registerCoreMember(QueueCommand.class, "QUEUE", "queue (<queue>) [clear/stop/pause/resume/delay:<#>]", 1);
        this.registerCoreMember(RandomCommand.class, "RANDOM", "random [<#>/<commands>]", 0);
        this.registerCoreMember(ReloadCommand.class, "RELOAD", "reload", 0);
        this.registerCoreMember(RepeatCommand.class, "REPEAT", "repeat [stop/next/<amount>] [<commands>] (as:<name>)", 1);
        this.registerCoreMember(RunCommand.class, "RUN", "run (locally) [<script>] (path:<name>) (def:<element>|...) (id:<name>) (instantly) (speed:<value>) (delay:<value>)", 1);
        this.registerCoreMember(SQLCommand.class, "SQL", "sql [id:<ID>] [disconnect/connect:<server> (username:<username>) (password:<password>) (ssl:true/{false})/query:<query>/update:<update>]", 2);
        this.registerCoreMember(StopCommand.class, "STOP", "stop", 0);
        this.registerCoreMember(SyncCommand.class, "SYNC", "sync [<commands>]", 0);
        this.registerCoreMember(WaitCommand.class, "WAIT", "wait (<duration>) (queue:<name>)", 0);
        this.registerCoreMember(WaitUntilCommand.class, "WAITUNTIL", "waituntil [<comparisons>]", 0);
        this.registerCoreMember(WebGetCommand.class, "WEBGET", "webget [<url>] (post:<data>) (headers:<header>/<value>|...) (timeout:<duration>/{10s}) (savefile:<path>)", 1);
        this.registerCoreMember(WhileCommand.class, "WHILE", "while [stop/next/<comparison tag>] [<commands>]", 1);
        this.registerCoreMember(YamlCommand.class, "YAML", "yaml [create]/[load:<file> (fix_formatting)]/[loadtext:<text> (fix_formatting)]/[unload]/[savefile:<file>]/[copykey:<source key> <target key> (to_id:<name>)]/[set <key>([<#>])(:<action>):<value>] [id:<name>]", 2);
    }

    public <T extends AbstractCommand> void registerCoreMember(Class<T> cmd, String names, String hint, int args) {
        for (String name : names.split(", ")) {
            try {
                ((AbstractCommand)cmd.newInstance()).activate().as(name).withOptions(hint, args);
            }
            catch (Throwable e) {
                dB.echoError("Could not register command " + name + ": " + e.getMessage());
                dB.echoError(e);
            }
        }
    }

    @Override
    public void disableCoreMembers() {
        for (RegistrationableInstance registrationableInstance : this.instances.values()) {
            try {
                registrationableInstance.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + registrationableInstance.getClass().getName() + "'!");
                dB.echoError(e);
            }
        }
    }
}

