/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.scheduling.Schedulable;

public class WebGetCommand
extends AbstractCommand
implements Holdable {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("url")) {
                scriptEntry.addObject("url", new Element(arg.raw_value));
                continue;
            }
            if (!scriptEntry.hasObject("post") && arg.matchesOnePrefix("post")) {
                scriptEntry.addObject("post", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("timeout") && arg.matchesPrefix("timeout", "t") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("timeout", arg.asType(Duration.class));
                continue;
            }
            if (!scriptEntry.hasObject("headers") && arg.matchesPrefix("headers")) {
                scriptEntry.addObject("headers", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("savefile") && arg.matchesPrefix("savefile")) {
                scriptEntry.addObject("savefile", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("url")) {
            throw new InvalidArgumentsException("Must have a valid URL!");
        }
        Element url = scriptEntry.getElement("url");
        if (!url.asString().startsWith("http://") && !url.asString().startsWith("https://")) {
            throw new InvalidArgumentsException("Must have a valid (HTTP/HTTPS) URL! Attempted: " + url.asString());
        }
        scriptEntry.defaultObject("timeout", new Duration(10));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        if (!DenizenCore.getImplementation().allowedToWebget()) {
            dB.echoError(scriptEntry.getResidingQueue(), "WebGet disabled by config!");
            return;
        }
        final Element url = scriptEntry.getElement("url");
        final Element postData = scriptEntry.getElement("post");
        final Duration timeout = (Duration)scriptEntry.getdObject("timeout");
        final dList headers = (dList)scriptEntry.getdObject("headers");
        final Element saveFile = scriptEntry.getElement("savefile");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), url.debug() + (postData != null ? postData.debug() : "") + (timeout != null ? timeout.debug() : "") + (saveFile != null ? saveFile.debug() : "") + (headers != null ? headers.debug() : ""));
        }
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                WebGetCommand.this.webGet(scriptEntry, postData, url, timeout, headers, saveFile);
            }
        });
        thr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webGet(final ScriptEntry scriptEntry, Element postData, Element urlp, Duration timeout, dList headers, final Element saveFile) {
        BufferedReader buffIn = null;
        try {
            URL url = new URL(urlp.asString().replace(" ", "%20"));
            final HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            if (postData != null) {
                uc.setRequestMethod("POST");
            }
            if (headers != null) {
                for (String str : headers) {
                    int ind = str.indexOf(47);
                    if (ind <= 0) continue;
                    uc.setRequestProperty(str.substring(0, ind), str.substring(ind + 1));
                }
            }
            uc.setConnectTimeout((int)timeout.getMillis());
            uc.connect();
            if (postData != null) {
                uc.getOutputStream().write(postData.asString().getBytes("UTF-8"));
            }
            final StringBuilder sb = new StringBuilder();
            if (saveFile != null) {
                File file = new File(saveFile.asString());
                if (!DenizenCore.getImplementation().canWriteToFile(file)) {
                    dB.echoError("Cannot write to that file, as dangerous file paths have been disabled in the Denizen config.");
                } else {
                    int len;
                    InputStream in = uc.getInputStream();
                    FileOutputStream fout = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer)) > 0) {
                        fout.write(buffer, 0, len);
                    }
                    fout.flush();
                    fout.close();
                }
            } else {
                buffIn = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                try {
                    String temp;
                    while ((temp = buffIn.readLine()) != null) {
                        sb.append(temp).append("\n");
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                buffIn.close();
                buffIn = null;
            }
            DenizenCore.schedule(new Schedulable(){

                @Override
                public boolean tick(float seconds) {
                    try {
                        scriptEntry.addObject("failed", new Element(uc.getResponseCode() == 200 ? "false" : "true"));
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                    }
                    if (saveFile == null) {
                        scriptEntry.addObject("result", new Element(sb.toString()));
                    }
                    scriptEntry.setFinished(true);
                    return false;
                }
            });
        }
        catch (Exception e) {
            dB.echoError(e);
            try {
                DenizenCore.schedule(new Schedulable(){

                    @Override
                    public boolean tick(float seconds) {
                        scriptEntry.addObject("failed", new Element("true"));
                        scriptEntry.setFinished(true);
                        return false;
                    }
                });
            }
            catch (Exception e2) {
                dB.echoError(e2);
            }
        }
        finally {
            try {
                if (buffIn != null) {
                    buffIn.close();
                }
            }
            catch (Exception e) {
                dB.echoError(e);
            }
        }
    }
}

