/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.file;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.scheduling.AsyncSchedulable;
import net.aufdemrand.denizencore.utilities.scheduling.OneTimeSchedulable;

public class FileCopyCommand
extends AbstractCommand
implements Holdable {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o")) {
                scriptEntry.addObject("origin", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesPrefix("destination", "d")) {
                scriptEntry.addObject("destination", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("overwrite") && arg.matches("overwrite")) {
                scriptEntry.addObject("overwrite", new Element("true"));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("origin")) {
            throw new InvalidArgumentsException("Must have a valid origin!");
        }
        if (!scriptEntry.hasObject("destination")) {
            throw new InvalidArgumentsException("Must have a valid destination!");
        }
        scriptEntry.defaultObject("overwrite", new Element("false"));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        boolean disdir;
        Element origin = scriptEntry.getElement("origin");
        Element destination = scriptEntry.getElement("destination");
        Element overwrite = scriptEntry.getElement("overwrite");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), origin.debug() + destination.debug() + overwrite.debug());
        }
        if (!DenizenCore.getImplementation().allowFileCopy()) {
            dB.echoError(scriptEntry.getResidingQueue(), "File copy disabled by server administrator.");
            scriptEntry.addObject("success", new Element("false"));
            scriptEntry.setFinished(true);
            return;
        }
        final File o = new File(DenizenCore.getImplementation().getDataFolder(), origin.asString());
        final File d = new File(DenizenCore.getImplementation().getDataFolder(), destination.asString());
        boolean ow = overwrite.asBoolean();
        final boolean dexists = d.exists();
        boolean bl = disdir = d.isDirectory() || destination.asString().endsWith("/");
        if (!DenizenCore.getImplementation().canReadFile(o)) {
            dB.echoError("Server config denies reading files in that location.");
            scriptEntry.addObject("success", new Element("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (!o.exists()) {
            dB.echoError(scriptEntry.getResidingQueue(), "File copy failed, origin does not exist!");
            scriptEntry.addObject("success", new Element("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (!DenizenCore.getImplementation().canWriteToFile(d)) {
            dB.echoError(scriptEntry.getResidingQueue(), "Can't copy files to there!");
            scriptEntry.addObject("success", new Element("false"));
            scriptEntry.setFinished(true);
            return;
        }
        if (dexists && !disdir && !ow) {
            dB.echoDebug((Debuggable)scriptEntry, "File copy ignored, destination file already exists!");
            scriptEntry.addObject("success", new Element("false"));
            scriptEntry.setFinished(true);
            return;
        }
        Runnable runme = new Runnable(){

            @Override
            public void run() {
                try {
                    if (dexists && !disdir) {
                        d.delete();
                    }
                    if (disdir && !dexists) {
                        d.mkdirs();
                    }
                    if (o.isDirectory()) {
                        CoreUtilities.copyDirectory(o, d);
                    } else {
                        Files.copy(o.toPath(), disdir ? d.toPath().resolve(o.toPath().getFileName()) : d.toPath(), new CopyOption[0]);
                    }
                    scriptEntry.addObject("success", new Element("true"));
                    scriptEntry.setFinished(true);
                }
                catch (Exception e) {
                    dB.echoError(scriptEntry.getResidingQueue(), e);
                    scriptEntry.addObject("success", new Element("false"));
                    scriptEntry.setFinished(true);
                }
            }
        };
        if (scriptEntry.shouldWaitFor()) {
            DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(runme, 0.0f)));
        } else {
            runme.run();
        }
    }
}

