/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.queue;

import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class DetermineCommand
extends AbstractCommand {
    public static String DETERMINE_NONE = "none";

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (arg.matches("passive", "passively")) {
                scriptEntry.addObject("passively", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("outcome")) {
                scriptEntry.addObject("outcome", arg.hasPrefix() ? new Element(arg.raw_value) : arg.object);
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("passively", new Element(false));
        scriptEntry.defaultObject("outcome", new Element(DETERMINE_NONE));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        dList strs;
        Object outcomeObj = scriptEntry.getdObject("outcome");
        Element passively = scriptEntry.getElement("passively");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), outcomeObj.debug() + passively.debug());
        }
        if ((strs = scriptEntry.getResidingQueue().determinations) == null) {
            scriptEntry.getResidingQueue().determinations = strs = new dList();
        }
        strs.addObject((dObject)outcomeObj);
        if (!passively.asBoolean()) {
            scriptEntry.getResidingQueue().clear();
        }
    }
}

