/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.queue;

import java.util.List;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class InjectCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (arg.matches("instant", "instantly")) {
                scriptEntry.addObject("instant", new Element(true));
                continue;
            }
            if (arg.matches("local", "locally")) {
                scriptEntry.addObject("local", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class) && !arg.matchesPrefix("p", "path")) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("path")) {
                dScript script;
                int dotIndex;
                String path = arg.asElement().asString();
                if (!scriptEntry.hasObject("script") && (dotIndex = path.indexOf(46)) > 0 && (script = new dScript(path.substring(0, dotIndex))).isValid()) {
                    scriptEntry.addObject("script", script);
                    path = path.substring(dotIndex + 1);
                }
                scriptEntry.addObject("path", new Element(path));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be injected.");
        }
        if (!scriptEntry.hasObject("path") && scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must specify a PATH.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (scriptEntry.hasObject("script") ? scriptEntry.getdObject("script").debug() : scriptEntry.getScript().debug()) + (scriptEntry.hasObject("instant") ? scriptEntry.getdObject("instant").debug() : "") + (scriptEntry.hasObject("path") ? scriptEntry.getElement("path").debug() : "") + (scriptEntry.hasObject("local") ? scriptEntry.getElement("local").debug() : ""));
        }
        dScript script = (dScript)scriptEntry.getdObject("script");
        List<ScriptEntry> entries = scriptEntry.hasObject("local") ? scriptEntry.getScript().getContainer().getEntries(scriptEntry.entryData.clone(), scriptEntry.getElement("path").asString()) : (scriptEntry.hasObject("path") ? script.getContainer().getEntries(scriptEntry.entryData.clone(), scriptEntry.getElement("path").asString()) : script.getContainer().getBaseEntries(scriptEntry.entryData.clone()));
        if (entries == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Script inject failed (invalid path or script name)!");
            return;
        }
        if (scriptEntry.hasObject("instant")) {
            scriptEntry.getResidingQueue().runNow(entries, "INJECT");
        } else {
            scriptEntry.getResidingQueue().injectEntries(entries, 0);
        }
    }
}

