/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.queue;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.scripts.commands.queue.IfCommand;
import net.aufdemrand.denizencore.scripts.queues.core.TimedQueue;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.scheduling.RepeatingSchedulable;

public class WaitUntilCommand
extends AbstractCommand
implements Holdable {
    @Override
    public void onEnable() {
        this.setBraced();
        this.setParseArgs(false);
        this.forceHold = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ArrayList<String> comparisons = new ArrayList<String>();
        for (String arg : scriptEntry.getArguments()) {
            if (arg.equals("{")) break;
            comparisons.add(arg);
        }
        scriptEntry.addObject("comparisons", comparisons);
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        final List comparisons = (List)scriptEntry.getObject("comparisons");
        boolean run = new IfCommand.ArgComparer().compare(new ArrayList(comparisons), scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("run_first_check", run));
        }
        if (run) {
            scriptEntry.setFinished(true);
            return;
        }
        final RepeatingSchedulable schedulable = new RepeatingSchedulable(null, scriptEntry.getResidingQueue() instanceof TimedQueue ? (float)((TimedQueue)scriptEntry.getResidingQueue()).getSpeed().getSeconds() : 0.05f);
        schedulable.run = new Runnable(){
            public int counter = 0;

            @Override
            public void run() {
                ++this.counter;
                if (new IfCommand.ArgComparer().compare(new ArrayList(comparisons), scriptEntry)) {
                    dB.echoDebug((Debuggable)scriptEntry, "WaitUntil completed after " + this.counter + " re-checks.");
                    scriptEntry.setFinished(true);
                    schedulable.cancel();
                }
            }
        };
        DenizenCore.schedule(schedulable);
    }
}

