/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class Attribute {
    private static HashMap<String, AttributeComponent[]> attribsLookup = new HashMap();
    public AttributeComponent[] attributes;
    public dObject[] contexts;
    ScriptEntry scriptEntry;
    public TagContext context;
    private String raw_tag;
    private String raw_tag_low;
    private int rawtaglen = -1;
    String origin;
    int fulfilled = 0;
    private boolean hadAlternative = false;

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static AttributeComponent[] separate_attributes(String attributes) {
        AttributeComponent[] matchesRes = attribsLookup.get(attributes);
        if (matchesRes != null) {
            return matchesRes;
        }
        ArrayList<AttributeComponent> matches = new ArrayList<AttributeComponent>();
        int x1 = 0;
        int x2 = -1;
        int braced = 0;
        char[] attrInp = attributes.toCharArray();
        for (int x = 0; x < attrInp.length; ++x) {
            Character chr = Character.valueOf(attrInp[x]);
            if (chr.charValue() == '[') {
                ++braced;
            } else if (x == attrInp.length - 1) {
                x2 = x + 1;
            } else if (chr.charValue() == ']') {
                if (braced > 0) {
                    --braced;
                }
            } else if (!(chr.charValue() != '.' || x > 0 && Attribute.isNumber(attrInp[x + 1]) && Attribute.isNumber(attrInp[x - 1]) || braced != 0)) {
                x2 = x;
            }
            if (x2 <= -1) continue;
            matches.add(new AttributeComponent(attributes.substring(x1, x2)));
            x2 = -1;
            x1 = x + 1;
        }
        if (dB.verbose) {
            dB.log("attribute splitter: '" + attributes + "' becomes: " + matches);
        }
        matchesRes = new AttributeComponent[matches.size()];
        matchesRes = matches.toArray(matchesRes);
        attribsLookup.put(attributes, matchesRes);
        return matchesRes;
    }

    public String getRawTag() {
        this.rebuild_raw_tag();
        return this.raw_tag;
    }

    public String getRawTagLow() {
        this.rebuild_raw_tag();
        return this.raw_tag_low;
    }

    public ScriptEntry getScriptEntry() {
        return this.scriptEntry;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Attribute(Attribute ref, ScriptEntry scriptEntry, TagContext context) {
        this.origin = ref.origin;
        this.scriptEntry = scriptEntry;
        this.context = context;
        this.attributes = ref.attributes;
        this.contexts = new dObject[this.attributes.length];
        this.hadAlternative = ref.hadAlternative;
    }

    public Attribute(String attributes, ScriptEntry scriptEntry, TagContext context) {
        this.origin = attributes;
        this.scriptEntry = scriptEntry;
        this.context = context;
        this.attributes = Attribute.separate_attributes(attributes);
        this.contexts = new dObject[this.attributes.length];
    }

    public boolean matches(String string) {
        if (this.fulfilled >= this.attributes.length) {
            return false;
        }
        return this.attributes[this.fulfilled].key.equalsIgnoreCase(string);
    }

    public boolean startsWith(String string) {
        if (this.fulfilled >= this.attributes.length) {
            return false;
        }
        if (string.contains(".")) {
            List<String> tmp;
            if (dB.verbose) {
                dB.log("Trying tag startsWith " + string + " on tag " + this.raw_tag);
            }
            if ((tmp = CoreUtilities.split(string, '.')).size() + this.fulfilled > this.attributes.length) {
                return false;
            }
            for (int i = 0; i < tmp.size(); ++i) {
                if (this.attributes[this.fulfilled + i].key.equals(tmp.get(i))) continue;
                return false;
            }
            return true;
        }
        return this.attributes[this.fulfilled].key.equalsIgnoreCase(string);
    }

    public boolean startsWith(String string, int attribute) {
        return CoreUtilities.toLowerCase(this.getAttribute(attribute)).startsWith(string);
    }

    public boolean isComplete() {
        return this.fulfilled >= this.attributes.length;
    }

    public Attribute fulfill(int attributes) {
        this.fulfilled += attributes;
        return this;
    }

    private void rebuild_raw_tag() {
        if (this.attributes.length == 0) {
            this.raw_tag = "";
            this.raw_tag_low = "";
            return;
        }
        if (this.fulfilled == this.rawtaglen) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (AttributeComponent attribute : this.attributes) {
            sb.append(attribute.toString()).append(".");
        }
        this.raw_tag = sb.toString();
        if (this.raw_tag.length() > 1) {
            this.raw_tag = this.raw_tag.substring(0, this.raw_tag.length() - 1);
        }
        this.raw_tag_low = CoreUtilities.toLowerCase(this.raw_tag);
        this.rawtaglen = this.fulfilled;
    }

    public boolean hasContext(int attribute) {
        if ((attribute += this.fulfilled - 1) < 0 || attribute >= this.attributes.length) {
            return false;
        }
        return this.attributes[attribute].context != null;
    }

    public dObject getContextObject(int attribute) {
        if ((attribute += this.fulfilled - 1) < 0 || attribute >= this.attributes.length) {
            return null;
        }
        dObject tagged = this.contexts[attribute];
        if (tagged != null) {
            return tagged;
        }
        String inp = this.attributes[attribute].context;
        if (inp == null) {
            return null;
        }
        this.contexts[attribute] = tagged = TagManager.tagObject(inp, this.context);
        return tagged;
    }

    public String getContext(int attribute) {
        return CoreUtilities.stringifyNullPass(this.getContextObject(attribute));
    }

    public boolean hasAlternative() {
        return this.hadAlternative;
    }

    public void setHadAlternative(boolean hadAlternative) {
        this.hadAlternative = hadAlternative;
    }

    public int getIntContext(int attribute) {
        try {
            if (this.hasContext(attribute)) {
                return Integer.valueOf(this.getContext(attribute));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public double getDoubleContext(int attribute) {
        try {
            if (this.hasContext(attribute)) {
                return Double.valueOf(this.getContext(attribute));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public String getAttribute(int num) {
        if ((num += this.fulfilled - 1) < 0 || num >= this.attributes.length) {
            return "";
        }
        return this.attributes[num].toString();
    }

    public String getAttributeWithoutContext(int num) {
        if ((num += this.fulfilled - 1) < 0 || num >= this.attributes.length) {
            return "";
        }
        return CoreUtilities.toLowerCase(this.attributes[num].key);
    }

    public String unfilledString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.fulfilled; i < this.attributes.length; ++i) {
            if (this.contexts[i] != null) {
                sb.append(this.attributes[i].key).append("[").append(this.contexts[i]).append("].");
                continue;
            }
            sb.append(this.attributes[i].toString()).append(".");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.contexts[i] != null) {
                sb.append(this.attributes[i].key).append("[").append(this.contexts[i]).append("].");
                continue;
            }
            sb.append(this.attributes[i].toString()).append(".");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public static class AttributeComponent {
        public final String rawKey;
        public final String key;
        public final String context;

        public AttributeComponent(String inp) {
            if (inp.endsWith("]") && inp.contains("[")) {
                int ind = inp.indexOf(91);
                this.rawKey = inp.substring(0, ind);
                this.context = inp.substring(ind + 1, inp.length() - 1);
            } else {
                this.rawKey = inp;
                this.context = null;
            }
            this.key = CoreUtilities.toLowerCase(this.rawKey);
        }

        public String toString() {
            if (this.context != null) {
                return this.key + "[" + this.context + "]";
            }
            return this.key;
        }
    }
}

