/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags.core;

import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class EscapeTags {
    public EscapeTags() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                EscapeTags.this.escapeTags(event);
            }
        }, "escape");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                EscapeTags.this.unEscapeTags(event);
            }
        }, "unescape");
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        return TagManager.cleanOutputFully(input).replace("&", "&amp").replace("|", "&pipe").replace(">", "&gt").replace("<", "&lt").replace("\n", "&nl").replace(";", "&sc").replace("[", "&lb").replace("]", "&rb").replace(":", "&co").replace("@", "&at").replace(".", "&dot").replace("\\", "&bs").replace("'", "&sq").replace("\"", "&quo").replace("!", "&exc").replace("/", "&fs").replace("\u00a7", "&ss").replace("#", "&ns");
    }

    public static String unEscape(String input) {
        if (input == null) {
            return null;
        }
        return TagManager.cleanOutputFully(input).replace("&pipe", "|").replace("&nl", "\n").replace("&gt", ">").replace("&lt", "<").replace("&sc", ";").replace("&sq", "'").replace("&lb", "[").replace("&rb", "]").replace("&sp", String.valueOf('\u00a0')).replace("&co", ":").replace("&at", "@").replace("&dot", ".").replace("&bs", "\\").replace("&quo", "\"").replace("&exc", "!").replace("&fs", "/").replace("&ss", "\u00a7").replace("&ns", "#").replace("&amp", "&");
    }

    public void escapeTags(ReplaceableTagEvent event) {
        if (event.matches("escape")) {
            if (!event.hasValue()) {
                dB.echoError("Escape tag '" + event.raw_tag + "' does not have a value!");
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new Element(EscapeTags.escape(event.getValue())), event.getAttributes().fulfill(1)));
        }
    }

    public void unEscapeTags(ReplaceableTagEvent event) {
        if (event.matches("unescape")) {
            if (!event.hasValue()) {
                dB.echoError("Unescape tag '" + event.raw_tag + "' does not have a value!");
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new Element(EscapeTags.unEscape(event.getValue())), event.getAttributes().fulfill(1)));
        }
    }
}

