/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.utilities.data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.data.ActionableDataProvider;
import net.aufdemrand.denizencore.utilities.data.DataActionException;
import net.aufdemrand.denizencore.utilities.data.DataActionType;

public class DataAction {
    public ActionableDataProvider provider;
    public DataActionType type;
    public String key;
    public int index = 0;
    public dObject inputValue = null;

    public String debug() {
        return aH.debugObj("action", "(" + this.key + "[" + this.index + "]:" + (Object)((Object)this.type) + ":" + this.inputValue + ")");
    }

    public dList autoList(String key) {
        dObject obj = this.provider.getValueAt(key);
        if (obj == null) {
            return new dList();
        }
        return this.autoList(dList.getListFor(obj));
    }

    public dList autoList(dList list) {
        return new dList(list);
    }

    public dObject autoDup(dObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof dList) {
            return this.autoList((dList)object);
        }
        return new Element(object.toString());
    }

    public BigDecimal autoNumber() {
        dObject obj = this.provider.getValueAt(this.key);
        if (this.index != 0) {
            dList subList = dList.getListFor(obj);
            if (this.index < 0 || this.index > subList.size()) {
                return BigDecimal.ZERO;
            }
            obj = subList.getObject(this.index - 1);
        }
        try {
            return this.autoNumber(obj);
        }
        catch (NumberFormatException ex) {
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal autoNumber(dObject obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(obj.toString());
    }

    public Element autoNumber(BigDecimal decimal) {
        return new Element(decimal);
    }

    public void autoSet(dObject value) {
        if (this.index != 0) {
            dObject obj = this.provider.getValueAt(this.key);
            dList subList = dList.getListFor(obj);
            subList.setObject(this.index - 1, value);
            value = subList;
        }
        this.provider.setValueAt(this.key, value);
    }

    public void requiresInputValue() {
        if (this.inputValue == null) {
            throw new DataActionException("Input value required for data action " + (Object)((Object)this.type) + ".");
        }
    }

    public void execute() {
        switch (this.type) {
            case INCREMENT: {
                BigDecimal num = this.autoNumber();
                num = num.add(BigDecimal.ONE);
                this.autoSet(this.autoNumber(num));
                break;
            }
            case DECREMENT: {
                BigDecimal num = this.autoNumber();
                num = num.subtract(BigDecimal.ONE);
                this.autoSet(this.autoNumber(num));
                break;
            }
            case ADD: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber();
                num = num.add(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num));
                break;
            }
            case SUBTRACT: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber();
                num = num.subtract(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num));
                break;
            }
            case MULTIPLY: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber();
                num = num.multiply(this.autoNumber(this.inputValue));
                this.autoSet(this.autoNumber(num));
                break;
            }
            case DIVIDE: {
                this.requiresInputValue();
                BigDecimal num = this.autoNumber();
                num = num.setScale(15, RoundingMode.HALF_UP);
                num = num.divide(this.autoNumber(this.inputValue), RoundingMode.HALF_UP);
                this.autoSet(this.autoNumber(num));
                break;
            }
            case INSERT: {
                this.requiresInputValue();
                dList list = this.autoList(this.key);
                list.addObject(this.inputValue);
                this.provider.setValueAt(this.key, list);
                break;
            }
            case REMOVE: {
                dList list = this.autoList(this.key);
                if (this.index != 0) {
                    list.remove(this.index - 1);
                }
                this.requiresInputValue();
                String findValue = CoreUtilities.toLowerCase(this.inputValue.toString());
                for (int i = 0; i < list.size(); ++i) {
                    if (!CoreUtilities.toLowerCase((String)list.get(i)).equals(findValue)) continue;
                    list.remove(i);
                    break;
                }
                this.provider.setValueAt(this.key, list);
                break;
            }
            case SPLIT: {
                this.requiresInputValue();
                dList list = this.autoList(this.key);
                list.addObjects(dList.getListFor((dObject)this.inputValue).objectForms);
                this.provider.setValueAt(this.key, list);
                break;
            }
            case SPLIT_NEW: {
                this.requiresInputValue();
                this.provider.setValueAt(this.key, this.autoList(dList.getListFor(this.inputValue)));
                break;
            }
            case SET: {
                this.requiresInputValue();
                this.provider.setValueAt(this.key, this.autoDup(this.inputValue));
                break;
            }
            case AUTO_SET: {
                this.provider.setValueAt(this.key, new Element(true));
                break;
            }
            case CLEAR: {
                this.provider.setValueAt(this.key, null);
            }
        }
    }
}

