/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.core;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.OldSmartEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class CommandSmartEvent
implements OldSmartEvent,
Listener {
    List<CommandHandlerData> cmds = new ArrayList<CommandHandlerData>();

    @Override
    public boolean shouldInitialize(Set<String> events) {
        this.cmds = new ArrayList<CommandHandlerData>();
        boolean pass = false;
        for (String event : events) {
            Matcher m = Pattern.compile("on( ([^\\s]+))? command(in \\w+)?", 2).matcher(event);
            if (!m.matches()) continue;
            String cmd = m.group(2);
            if (cmd != null) {
                ListTag split = ListTag.valueOf(cmd);
                for (String str : split) {
                    this.cmds.add(new CommandHandlerData(CoreUtilities.toLowerCase(str), cmd));
                }
            }
            pass = true;
        }
        return pass;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        Debug.log("Loaded Command SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerCommandPreprocessEvent.getHandlerList().unregister((Listener)this);
        ServerCommandEvent.getHandlerList().unregister((Listener)this);
    }

    private List<String> getAll(String cmd) {
        ArrayList<String> newEvents = new ArrayList<String>();
        cmd = CoreUtilities.toLowerCase(cmd);
        for (CommandHandlerData chd : this.cmds) {
            if (!chd.name.equalsIgnoreCase(cmd)) continue;
            newEvents.add(chd.event + " command");
        }
        return newEvents;
    }

    @EventHandler
    public void playerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        String message = event.getMessage();
        String command = message.split(" ")[0].substring(1).toUpperCase();
        ArrayList<String> events = new ArrayList<String>();
        events.add("command");
        events.add(command + " command");
        events.addAll(this.getAll(command));
        List<CuboidTag> cuboids = CuboidTag.getNotableCuboidsContaining(event.getPlayer().getLocation());
        ListTag cuboid_context = new ListTag();
        ArrayList<String> cuboidEvents = new ArrayList<String>();
        for (CuboidTag cuboid : cuboids) {
            for (String str : events) {
                cuboidEvents.add(str + " in " + cuboid.identifySimple());
            }
            cuboid_context.add(cuboid.identifySimple());
        }
        for (String str : events) {
            cuboidEvents.add(str + " in " + new WorldTag(event.getPlayer().getLocation().getWorld()).identifySimple());
        }
        events.addAll(cuboidEvents);
        context.put("cuboids", cuboid_context);
        List<String> args = Arrays.asList(ArgumentHelper.buildArgs(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        context.put("args", new ListTag(args));
        context.put("parsed_args", new ListTag(args));
        context.put("command", new ElementTag(command));
        context.put("raw_args", new ElementTag(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        context.put("server", new ElementTag(false));
        String determination = BukkitWorldScriptHelper.doEvents(events, null, EntityTag.getPlayerFrom((Entity)event.getPlayer()), context, true).toUpperCase();
        if (determination.equals("FULFILLED") || determination.equals("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void serverCommand(ServerCommandEvent event) {
        if (event.getCommand().trim().length() == 0) {
            return;
        }
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        String message = event.getCommand();
        String command = event.getCommand().split(" ")[0].replace("/", "").toUpperCase();
        ArrayList<String> events = new ArrayList<String>();
        events.add("command");
        events.add(command + " command");
        events.addAll(this.getAll(command));
        List<String> args = Arrays.asList(ArgumentHelper.buildArgs(message.split(" ").length > 1 ? message.split(" ", 2)[1] : ""));
        List<String> parsed_args = Arrays.asList(ArgumentHelper.buildArgs(event.getCommand().split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : ""));
        context.put("args", new ListTag(args));
        context.put("parsed_args", new ListTag(parsed_args));
        context.put("command", new ElementTag(command));
        context.put("raw_args", new ElementTag(message.split(" ").length > 1 ? event.getCommand().split(" ", 2)[1] : ""));
        context.put("server", new ElementTag(true));
        CommandSender sender = event.getSender();
        if (sender instanceof BlockCommandSender) {
            context.put("command_block_location", new LocationTag(((BlockCommandSender)sender).getBlock().getLocation()));
        } else if (sender instanceof CommandMinecart) {
            context.put("command_minecart", new EntityTag((Entity)((CommandMinecart)sender)));
        }
        String determination = BukkitWorldScriptHelper.doEvents(events, null, null, context);
        if (determination.equalsIgnoreCase("FULFILLED") || determination.equalsIgnoreCase("CANCELLED")) {
            event.setCommand("denizen do_nothing");
        }
    }

    class CommandHandlerData {
        public final String name;
        public final String event;

        public CommandHandlerData(String name, String event) {
            this.name = name;
            this.event = event;
        }
    }
}

