/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;

public class EntityBreedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityBreedScriptEvent instance;
    private EntityTag entity;
    private EntityTag breeder;
    private EntityTag father;
    private EntityTag mother;
    private ItemTag item;
    private int experience;
    public EntityBreedEvent event;

    public EntityBreedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("breeds");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityBreeds";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.experience = ((ElementTag)determinationObj).asInt();
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("child")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("breeder")) {
            return this.breeder.getDenizenObject();
        }
        if (name.equals("father")) {
            return this.father.getDenizenObject();
        }
        if (name.equals("mother")) {
            return this.mother.getDenizenObject();
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("experience")) {
            return new ElementTag(this.experience);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityBreeds(EntityBreedEvent event) {
        LivingEntity entity = event.getEntity();
        this.entity = new EntityTag((Entity)entity);
        this.breeder = new EntityTag((Entity)event.getBreeder());
        this.father = new EntityTag((Entity)event.getFather());
        this.mother = new EntityTag((Entity)event.getMother());
        this.item = new ItemTag(event.getBredWith());
        this.experience = event.getExperience();
        boolean wasCancelled = event.isCancelled();
        this.event = event;
        EntityTag.rememberEntity((Entity)entity);
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)entity);
        event.setExperience(this.experience);
        if (this.cancelled && !wasCancelled) {
            NMSHandler.getInstance().getEntityHelper().setBreeding((Animals)this.father.getLivingEntity(), false);
            NMSHandler.getInstance().getEntityHelper().setBreeding((Animals)this.mother.getLivingEntity(), false);
        }
    }
}

