/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntitySpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntitySpawnScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    public ElementTag reason;
    public CreatureSpawnEvent event;

    public EntitySpawnScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "spawns") && !lower.startsWith("item") && !lower.startsWith("spawner");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("because") && !path.eventArgLowerAt(3).equalsIgnoreCase(this.reason.toString())) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "EntitySpawn";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? EntityTag.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity.isCitizensNPC() ? EntityTag.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("cuboids")) {
            Debug.echoError("context.cuboids tag is deprecated in " + this.getName() + " script event");
            ListTag cuboids = new ListTag();
            for (CuboidTag cuboid : CuboidTag.getNotableCuboidsContaining(this.location)) {
                cuboids.add(cuboid.identifySimple());
            }
            return cuboids;
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        this.entity = new EntityTag((Entity)entity);
        this.location = new LocationTag(event.getLocation());
        this.reason = new ElementTag(event.getSpawnReason().name());
        this.event = event;
        EntityTag.rememberEntity((Entity)entity);
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)entity);
    }
}

