/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;

public class PlayerConsumesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerConsumesScriptEvent instance;
    public ItemTag item;
    public PlayerItemConsumeEvent event;

    public PlayerConsumesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player consumes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String iCheck = path.eventArgLowerAt(2);
        return this.tryItem(this.item, iCheck) && this.runInCheck(path, this.event.getPlayer().getLocation());
    }

    @Override
    public String getName() {
        return "PlayerConsumes";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            ItemTag newitem = ItemTag.valueOf(determination, EntityTag.getPlayerFrom((Entity)this.event.getPlayer()), null);
            if (newitem != null) {
                this.event.setItem(newitem.getItemStack());
                return true;
            }
            Debug.echoError("Invalid event 'item' check [" + this.getName() + "] ('determine item ????'): '" + determination + "' for " + path.container.getName());
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event != null ? EntityTag.getPlayerFrom((Entity)this.event.getPlayer()) : null, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerConsumes(PlayerItemConsumeEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.item = new ItemTag(event.getItem());
        this.event = event;
        this.fire((Event)event);
    }
}

