/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkTag
implements ObjectTag,
Adjustable {
    int chunkX;
    int chunkZ;
    WorldTag world;
    Chunk cachedChunk;
    String prefix = "Chunk";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static ChunkTag valueOf(String string) {
        return ChunkTag.valueOf(string, null);
    }

    @Fetchable(value="ch")
    public static ChunkTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String[] parts = (string = CoreUtilities.toLowerCase(string).replace("ch@", "")).split(",");
        if (parts.length == 3) {
            try {
                return new ChunkTag(WorldTag.valueOf(parts[2], context), Integer.valueOf(parts[0]), Integer.valueOf(parts[1]));
            }
            catch (Exception e) {
                if (context == null || context.debug) {
                    Debug.log("Minor: valueOf ChunkTag returning null: ch@" + string);
                }
                return null;
            }
        }
        if (context == null || context.debug) {
            Debug.log("Minor: valueOf ChunkTag unable to handle malformed format: ch@" + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        return CoreUtilities.toLowerCase(string).startsWith("ch@");
    }

    public Chunk getChunk() {
        if (this.cachedChunk == null) {
            this.cachedChunk = this.world.getWorld().getChunkAt(this.chunkX, this.chunkZ);
        }
        return this.cachedChunk;
    }

    public ChunkTag(Chunk chunk) {
        this.cachedChunk = chunk;
        this.world = new WorldTag(chunk.getWorld());
        this.chunkX = chunk.getX();
        this.chunkZ = chunk.getZ();
    }

    public ChunkTag(WorldTag world, int x, int z) {
        this.world = world;
        this.chunkX = x;
        this.chunkZ = z;
    }

    public ChunkTag(Location location) {
        this.world = new WorldTag(location.getWorld());
        this.chunkX = location.getBlockX() >> 4;
        this.chunkZ = location.getBlockZ() >> 4;
    }

    public LocationTag getCenter() {
        return new LocationTag(this.getWorld(), this.getX() * 16 + 8, 128.0, this.getZ() * 16 + 8);
    }

    public int getX() {
        return this.chunkX;
    }

    public int getZ() {
        return this.chunkZ;
    }

    public World getWorld() {
        return this.world.getWorld();
    }

    public ChunkSnapshot getSnapshot() {
        return this.getChunk().getChunkSnapshot();
    }

    public int[] getHeightMap() {
        return NMSHandler.getInstance().getChunkHelper().getHeightMap(this.getChunk());
    }

    @Override
    public String getObjectType() {
        return "Chunk";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ChunkTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String identify() {
        return "ch@" + this.getX() + ',' + this.getZ() + ',' + this.getWorld().getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public boolean isLoaded() {
        return this.world.getWorld().isChunkLoaded(this.chunkX, this.chunkZ);
    }

    public static void registerTags() {
        ChunkTag.registerTag("add", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ChunkTag.add[<#>,<#>] must have a value.");
                    return null;
                }
                List<String> coords = CoreUtilities.split(attribute.getContext(1), ',');
                if (coords.size() < 2) {
                    Debug.echoError("The tag ChunkTag.add[<#>,<#>] requires two values!");
                    return null;
                }
                int x = ArgumentHelper.getIntegerFrom(coords.get(0));
                int z = ArgumentHelper.getIntegerFrom(coords.get(1));
                ChunkTag chunk = (ChunkTag)object;
                return new ChunkTag(chunk.world, chunk.chunkX + x, chunk.chunkZ + z).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("sub", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag ChunkTag.add[<#>,<#>] must have a value.");
                    return null;
                }
                List<String> coords = CoreUtilities.split(attribute.getContext(1), ',');
                if (coords.size() < 2) {
                    Debug.echoError("The tag ChunkTag.sub[<#>,<#>] requires two values!");
                    return null;
                }
                int x = ArgumentHelper.getIntegerFrom(coords.get(0));
                int z = ArgumentHelper.getIntegerFrom(coords.get(1));
                ChunkTag chunk = (ChunkTag)object;
                return new ChunkTag(chunk.world, chunk.chunkX - x, chunk.chunkZ - z).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("is_loaded", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ChunkTag)object).isLoaded()).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("x", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ChunkTag)object).chunkX).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("z", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((ChunkTag)object).chunkZ).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("world", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return ((ChunkTag)object).world.getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("cuboid", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ChunkTag chunk = (ChunkTag)object;
                return new CuboidTag(new Location(chunk.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16)), new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 15), 255.0, (double)(chunk.getZ() * 16 + 15))).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ListTag entities = new ListTag();
                if (((ChunkTag)object).isLoaded()) {
                    for (Entity ent : ((ChunkTag)object).getChunk().getEntities()) {
                        entities.addObject(new EntityTag(ent).getDenizenObject());
                    }
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("living_entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ListTag entities = new ListTag();
                if (((ChunkTag)object).isLoaded()) {
                    for (Entity ent : ((ChunkTag)object).getChunk().getEntities()) {
                        if (!(ent instanceof LivingEntity)) continue;
                        entities.addObject(new EntityTag(ent).getDenizenObject());
                    }
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("players", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ListTag entities = new ListTag();
                if (((ChunkTag)object).isLoaded()) {
                    for (Entity ent : ((ChunkTag)object).getChunk().getEntities()) {
                        if (!EntityTag.isPlayer(ent)) continue;
                        entities.addObject(new PlayerTag((Player)ent));
                    }
                }
                return entities.getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("height_map", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                int[] heightMap = ((ChunkTag)object).getHeightMap();
                ArrayList<String> height_map = new ArrayList<String>(heightMap.length);
                for (int i : heightMap) {
                    height_map.add(String.valueOf(i));
                }
                return new ListTag((List<String>)height_map).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("average_height", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                int[] heightMap;
                int sum = 0;
                for (int i : heightMap = ((ChunkTag)object).getHeightMap()) {
                    sum += i;
                }
                return new ElementTag((double)sum / (double)heightMap.length).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("is_flat", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                int tolerance = attribute.hasContext(1) && ArgumentHelper.matchesInteger(attribute.getContext(1)) ? Integer.valueOf(attribute.getContext(1)) : 2;
                int[] heightMap = ((ChunkTag)object).getHeightMap();
                int x = heightMap[0];
                for (int i : heightMap) {
                    if (Math.abs(x - i) <= tolerance) continue;
                    return new ElementTag(false).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(true).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("surface_blocks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ListTag surface_blocks = new ListTag();
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        surface_blocks.add(new LocationTag(((ChunkTag)object).getChunk().getBlock(x, ((ChunkTag)object).getSnapshot().getHighestBlockYAt(x, z) - 1, z).getLocation()).identify());
                    }
                }
                return surface_blocks.getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("spawn_slimes", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ChunkTag chunk = (ChunkTag)object;
                Random random = new Random(chunk.getWorld().getSeed() + (long)(chunk.getX() * chunk.getX() * 4987142) + (long)(chunk.getX() * 5947611) + (long)(chunk.getZ() * chunk.getZ()) * 4392871L + (long)(chunk.getZ() * 389711) ^ 0x3AD8025FL);
                return new ElementTag(random.nextInt(10) == 0).getAttribute(attribute.fulfill(1));
            }
        });
        ChunkTag.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Chunk").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                com.denizenscript.denizencore.utilities.debugging.Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a chunk!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("unload")) {
            this.getChunk().unload(true);
        }
        if (mechanism.matches("unload_safely")) {
            Debug.echoError("Mechanism 'dChunk.unload_safely' is not valid: It is never safe to remove a chunk in use.");
            this.getChunk().unload(true);
        }
        if (mechanism.matches("unload_without_saving")) {
            this.getChunk().unload(false);
        }
        if (mechanism.matches("load")) {
            this.getChunk().load(true);
        }
        if (mechanism.matches("regenerate")) {
            this.getWorld().regenerateChunk(this.getX(), this.getZ());
        }
        if (mechanism.matches("refresh_chunk")) {
            final int chunkX = this.getX();
            final int chunkZ = this.getZ();
            this.getWorld().refreshChunk(chunkX, chunkZ);
            new BukkitRunnable(){

                public void run() {
                    for (Map<LocationTag, FakeBlock> blocks : FakeBlock.getBlocks().values()) {
                        for (Map.Entry<LocationTag, FakeBlock> locBlock : blocks.entrySet()) {
                            LocationTag location = locBlock.getKey();
                            if (Math.floor(location.getX() / 16.0) != (double)chunkX || Math.floor(location.getZ() / 16.0) != (double)chunkZ) continue;
                            locBlock.getValue().updateBlock();
                        }
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 2L);
        }
        if (mechanism.matches("refresh_chunk_sections")) {
            NMSHandler.getInstance().getChunkHelper().refreshChunkSections(this.getChunk());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

