/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WorldTag
implements ObjectTag,
Adjustable {
    static Map<String, WorldTag> worlds = new HashMap<String, WorldTag>();
    private String prefix;
    String world_name;
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public static WorldTag mirrorBukkitWorld(World world) {
        if (world == null) {
            return null;
        }
        if (worlds.containsKey(world.getName())) {
            return worlds.get(world.getName());
        }
        return new WorldTag(world);
    }

    public static WorldTag valueOf(String string) {
        return WorldTag.valueOf(string, null);
    }

    @Fetchable(value="w")
    public static WorldTag valueOf(String string, TagContext context) {
        return WorldTag.valueOf(string, context == null || context.debug);
    }

    public static WorldTag valueOf(String string, boolean announce) {
        if (string == null) {
            return null;
        }
        string = string.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(string)) continue;
            returnable = world;
        }
        if (returnable != null) {
            if (worlds.containsKey(returnable.getName())) {
                return worlds.get(returnable.getName());
            }
            return new WorldTag(returnable);
        }
        if (announce) {
            Debug.echoError("Invalid World! '" + string + "' could not be found.");
        }
        return null;
    }

    public static boolean matches(String arg) {
        arg = arg.replace("w@", "");
        World returnable = null;
        for (World world : Bukkit.getWorlds()) {
            if (!world.getName().equalsIgnoreCase(arg)) continue;
            returnable = world;
        }
        return returnable != null;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world_name);
    }

    public String getName() {
        return this.world_name;
    }

    public List<Entity> getEntities() {
        return this.getWorld().getEntities();
    }

    public WorldTag(World world) {
        this(null, world);
    }

    public WorldTag(String prefix, World world) {
        this.prefix = prefix == null ? "World" : prefix;
        this.world_name = world.getName();
        if (!worlds.containsKey(world.getName())) {
            worlds.put(world.getName(), this);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "World";
    }

    @Override
    public String identify() {
        return "w@" + this.world_name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        WorldTag.registerTag("entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
                for (Entity entity : ((WorldTag)object).getWorld().getEntities()) {
                    entities.add(new EntityTag(entity));
                }
                return new ListTag((Collection<? extends ObjectTag>)entities).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("living_entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
                for (Entity entity : ((WorldTag)object).getWorld().getLivingEntities()) {
                    entities.add(new EntityTag(entity));
                }
                return new ListTag((Collection<? extends ObjectTag>)entities).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("players", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ArrayList<PlayerTag> players = new ArrayList<PlayerTag>();
                for (Player player : ((WorldTag)object).getWorld().getPlayers()) {
                    if (EntityTag.isNPC((Entity)player)) continue;
                    players.add(new PlayerTag(player));
                }
                return new ListTag((Collection<? extends ObjectTag>)players).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("spawned_npcs", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
                World thisWorld = ((WorldTag)object).getWorld();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    if (!npc.isSpawned() || !npc.getEntity().getLocation().getWorld().equals(thisWorld)) continue;
                    npcs.add(NPCTag.mirrorCitizensNPC(npc));
                }
                return new ListTag((Collection<? extends ObjectTag>)npcs).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("npcs", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
                World thisWorld = ((WorldTag)object).getWorld();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    World world;
                    Location location = npc.getStoredLocation();
                    if (location == null || (world = location.getWorld()) == null || !world.equals(thisWorld)) continue;
                    npcs.add(NPCTag.mirrorCitizensNPC(npc));
                }
                return new ListTag((Collection<? extends ObjectTag>)npcs).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("can_generate_structures", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().canGenerateStructures()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("loaded_chunks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                ListTag chunks = new ListTag();
                for (Chunk ent : ((WorldTag)object).getWorld().getLoadedChunks()) {
                    chunks.add(new ChunkTag(ent).identify());
                }
                return chunks.getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("random_loaded_chunk", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                int random = CoreUtilities.getRandom().nextInt(((WorldTag)object).getWorld().getLoadedChunks().length);
                return new ChunkTag(((WorldTag)object).getWorld().getLoadedChunks()[random]).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("sea_level", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getSeaLevel()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("spawn_location", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new LocationTag(((WorldTag)object).getWorld().getSpawnLocation()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("world_type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getWorldType().getName()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getName()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("seed", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getSeed()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("allows_animals", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getAllowAnimals()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("allows_monsters", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getAllowMonsters()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("allows_pvp", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getPVP()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("auto_save", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().isAutoSave()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("ambient_spawn_limit", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getAmbientSpawnLimit()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("animal_spawn_limit", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getAnimalSpawnLimit()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("monster_spawn_limit", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getMonsterSpawnLimit()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("water_animal_spawn_limit", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getWaterAnimalSpawnLimit()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("difficulty", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getDifficulty().name()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("keep_spawn", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getKeepSpawnInMemory()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("max_height", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getMaxHeight()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("ticks_per_animal_spawn", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new DurationTag(((WorldTag)object).getWorld().getTicksPerAnimalSpawns()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("ticks_per_monster_spawn", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new DurationTag(((WorldTag)object).getWorld().getTicksPerMonsterSpawns()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("time", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("duration")) {
                    return new DurationTag(((WorldTag)object).getWorld().getTime()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("full")) {
                    return new ElementTag(((WorldTag)object).getWorld().getFullTime()).getAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("period")) {
                    long time = ((WorldTag)object).getWorld().getTime();
                    String period = time >= 23000L ? "dawn" : (time >= 13500L ? "night" : (time >= 12500L ? "dusk" : "day"));
                    return new ElementTag(period).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((WorldTag)object).getWorld().getTime()).getAttribute(attribute);
            }
        });
        WorldTag.registerTag("moon_phase", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag((int)(((WorldTag)object).getWorld().getFullTime() / 24000L % 8L) + 1).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("moonphase", registeredTags.get("moon_phase"));
        WorldTag.registerTag("has_storm", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().hasStorm()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("thunder_duration", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new DurationTag((long)((WorldTag)object).getWorld().getThunderDuration()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("thundering", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().isThundering()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("weather_duration", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new DurationTag((long)((WorldTag)object).getWorld().getWeatherDuration()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("environment", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getEnvironment().name()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag("World").getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("border_size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getWorldBorder().getSize()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("border_center", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new LocationTag(((WorldTag)object).getWorld().getWorldBorder().getCenter()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("border_damage", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getWorldBorder().getDamageAmount()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("border_damage_buffer", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getWorldBorder().getDamageBuffer()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("border_warning_distance", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((WorldTag)object).getWorld().getWorldBorder().getWarningDistance()).getAttribute(attribute.fulfill(1));
            }
        });
        WorldTag.registerTag("border_warning_time", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new DurationTag(((WorldTag)object).getWorld().getWorldBorder().getWarningTime()).getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                com.denizenscript.denizencore.utilities.debugging.Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new ElementTag(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a world!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String upper;
        Difficulty diff;
        if (mechanism.matches("ambient_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setAmbientSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("animal_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setAnimalSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("auto_save") && mechanism.requireBoolean()) {
            this.getWorld().setAutoSave(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("difficulty") && mechanism.requireEnum(true, (Enum<?>[])Difficulty.values()) && (diff = (upper = mechanism.getValue().asString().toUpperCase()).matches("(PEACEFUL|EASY|NORMAL|HARD)") ? Difficulty.valueOf((String)upper) : Difficulty.getByValue((int)mechanism.getValue().asInt())) != null) {
            this.getWorld().setDifficulty(diff);
        }
        if (mechanism.matches("save")) {
            this.getWorld().save();
        }
        if (mechanism.matches("destroy")) {
            if (!Settings.allowDelete()) {
                Debug.echoError("Unable to delete due to config.");
                return;
            }
            File folder = new File(this.getWorld().getName());
            Bukkit.getServer().unloadWorld(this.getWorld(), false);
            try {
                CoreUtilities.deleteDirectory(folder);
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
            return;
        }
        if (mechanism.matches("force_unload")) {
            Bukkit.getServer().unloadWorld(this.getWorld(), false);
            return;
        }
        if (mechanism.matches("full_time") && mechanism.requireInteger()) {
            this.getWorld().setFullTime((long)mechanism.getValue().asInt());
        }
        if (mechanism.matches("keep_spawn") && mechanism.requireBoolean()) {
            this.getWorld().setKeepSpawnInMemory(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("monster_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setMonsterSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("allow_pvp") && mechanism.requireBoolean()) {
            this.getWorld().setPVP(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("spawn_location") && mechanism.requireObject(LocationTag.class)) {
            LocationTag loc = mechanism.valueAsType(LocationTag.class);
            this.getWorld().setSpawnLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }
        if (mechanism.matches("storming") && mechanism.requireBoolean()) {
            this.getWorld().setStorm(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("thunder_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setThunderDuration(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("thundering") && mechanism.requireBoolean()) {
            this.getWorld().setThundering(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("ticks_per_animal_spawns") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setTicksPerAnimalSpawns(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("ticks_per_monster_spawns") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setTicksPerMonsterSpawns(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            this.getWorld().setTime((long)mechanism.getValue().asInt());
        }
        if (mechanism.matches("unload")) {
            Bukkit.getServer().unloadWorld(this.getWorld(), true);
            return;
        }
        if (mechanism.matches("water_animal_spawn_limit") && mechanism.requireInteger()) {
            this.getWorld().setWaterAnimalSpawnLimit(mechanism.getValue().asInt());
        }
        if (mechanism.matches("weather_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getWorld().setWeatherDuration(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

