/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.notable;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class NotableManager {
    public static Map<String, Notable> notableObjects = new ConcurrentHashMap<String, Notable>();
    public static Map<String, Class> typeTracker = new ConcurrentHashMap<String, Class>();
    public static Map<Notable, String> reverseObjects = new ConcurrentHashMap<Notable, String>();
    private FileConfiguration notablesSave = null;
    private File notablesFile = null;
    private static Map<Class, String> objects = new HashMap<Class, String>();
    private static Map<String, Class> reverse_objects = new HashMap<String, Class>();

    public NotableManager() {
        NotableManager.registerWithNotableManager(CuboidTag.class);
        NotableManager.registerWithNotableManager(EllipsoidTag.class);
        NotableManager.registerWithNotableManager(InventoryTag.class);
        NotableManager.registerWithNotableManager(ItemTag.class);
        NotableManager.registerWithNotableManager(LocationTag.class);
    }

    public static boolean isSaved(String id) {
        return notableObjects.containsKey(CoreUtilities.toLowerCase(id));
    }

    public static boolean isSaved(Notable object) {
        return reverseObjects.containsKey(object);
    }

    public static boolean isExactSavedObject(Notable object) {
        String id = reverseObjects.get(object);
        if (id == null) {
            return false;
        }
        return notableObjects.get(id) == object;
    }

    public static Notable getSavedObject(String id) {
        if (notableObjects.containsKey(CoreUtilities.toLowerCase(id))) {
            return notableObjects.get(CoreUtilities.toLowerCase(id));
        }
        return null;
    }

    public static String getSavedId(Notable object) {
        if (reverseObjects.containsKey(object)) {
            return reverseObjects.get(object);
        }
        return null;
    }

    public static boolean isType(String id, Class type) {
        return typeTracker.containsKey(CoreUtilities.toLowerCase(id)) && typeTracker.get(CoreUtilities.toLowerCase(id)) == type;
    }

    public static void saveAs(Notable object, String id) {
        if (object == null) {
            return;
        }
        notableObjects.put(CoreUtilities.toLowerCase(id), object);
        reverseObjects.put(object, CoreUtilities.toLowerCase(id));
        typeTracker.put(CoreUtilities.toLowerCase(id), object.getClass());
    }

    public static void remove(String id) {
        Notable obj = notableObjects.get(CoreUtilities.toLowerCase(id));
        notableObjects.remove(CoreUtilities.toLowerCase(id));
        reverseObjects.remove(obj);
        typeTracker.remove(CoreUtilities.toLowerCase(id));
    }

    public static void remove(Notable obj) {
        String id = reverseObjects.get(obj);
        notableObjects.remove(CoreUtilities.toLowerCase(id));
        reverseObjects.remove(obj);
        typeTracker.remove(CoreUtilities.toLowerCase(id));
    }

    public static <T extends ObjectTag> List<T> getAllType(Class<T> type) {
        ArrayList<ObjectTag> objects = new ArrayList<ObjectTag>();
        for (Map.Entry<String, Notable> notable : notableObjects.entrySet()) {
            if (!NotableManager.isType(notable.getKey(), type)) continue;
            objects.add((ObjectTag)((Object)notable.getValue()));
        }
        return objects;
    }

    private static void _recallNotables() {
        notableObjects.clear();
        typeTracker.clear();
        reverseObjects.clear();
        for (String key : DenizenAPI.getCurrentInstance().notableManager().getNotables().getKeys(false)) {
            Class clazz = reverse_objects.get(key);
            ConfigurationSection section = DenizenAPI.getCurrentInstance().notableManager().getNotables().getConfigurationSection(key);
            if (section == null) continue;
            for (String notableRaw : section.getKeys(false)) {
                String notable = EscapeTagBase.unEscape(notableRaw.replace("DOT", "."));
                Notable obj = (Notable)ObjectFetcher.getObjectFrom(clazz, section.getString(notableRaw), Utilities.noDebugContext);
                if (obj != null) {
                    obj.makeUnique(notable);
                    continue;
                }
                Debug.echoError("Notable '" + notable + "' failed to load!");
            }
        }
    }

    private static void _saveNotables() {
        FileConfiguration notables = DenizenAPI.getCurrentInstance().notableManager().getNotables();
        for (String string : notables.getKeys(false)) {
            notables.set(string, null);
        }
        for (Map.Entry entry : notableObjects.entrySet()) {
            try {
                notables.set(NotableManager.getClassId(NotableManager.getClass((Notable)entry.getValue())) + "." + EscapeTagBase.escape(CoreUtilities.toLowerCase((String)entry.getKey())), ((Notable)entry.getValue()).getSaveObject());
            }
            catch (Exception e) {
                Debug.echoError("Notable '" + (String)entry.getKey() + "' failed to save!");
                Debug.echoError(e);
            }
        }
    }

    private static <T extends Notable> Class<T> getClass(Notable notable) {
        for (Class clazz : objects.keySet()) {
            if (!clazz.isInstance(notable)) continue;
            return clazz;
        }
        return null;
    }

    public void reloadNotables() {
        if (this.notablesFile == null) {
            this.notablesFile = new File(DenizenAPI.getCurrentInstance().getDataFolder(), "notables.yml");
        }
        this.notablesSave = YamlConfiguration.loadConfiguration((File)this.notablesFile);
        NotableManager._recallNotables();
    }

    public FileConfiguration getNotables() {
        if (this.notablesSave == null) {
            this.reloadNotables();
        }
        return this.notablesSave;
    }

    public void saveNotables() {
        if (this.notablesSave == null || this.notablesFile == null) {
            return;
        }
        try {
            NotableManager._saveNotables();
            this.notablesSave.save(this.notablesFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.notablesFile, ex);
        }
    }

    public static void registerWithNotableManager(Class notable) {
        for (Method method : notable.getMethods()) {
            if (!method.isAnnotationPresent(Note.class)) continue;
            String note = method.getAnnotation(Note.class).value();
            objects.put(notable, note);
            reverse_objects.put(note, notable);
        }
    }

    public static boolean canFetch(Class notable) {
        return objects.containsKey(notable);
    }

    public static String getClassId(Class notable) {
        if (NotableManager.canFetch(notable)) {
            return objects.get(notable);
        }
        return null;
    }

    public static Map<String, Class> getReverseClassIdMap() {
        return reverse_objects;
    }
}

