/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;

public class EntityChestCarrier
implements Property {
    public static final String[] handledTags = new String[]{"carries_chest"};
    public static final String[] handledMechs = new String[]{"carries_chest"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && NMSHandler.getInstance().getEntityHelper().isChestedHorse(((EntityTag)entity).getBukkitEntity());
    }

    public static EntityChestCarrier getFrom(ObjectTag entity) {
        if (!EntityChestCarrier.describes(entity)) {
            return null;
        }
        return new EntityChestCarrier((EntityTag)entity);
    }

    private EntityChestCarrier(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        return NMSHandler.getInstance().getEntityHelper().isCarryingChest(this.entity.getBukkitEntity()) ? "true" : "false";
    }

    @Override
    public String getPropertyId() {
        return "carries_chest";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("carries_chest")) {
            return new ElementTag(NMSHandler.getInstance().getEntityHelper().isCarryingChest(this.entity.getBukkitEntity())).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("carries_chest") && mechanism.requireBoolean()) {
            NMSHandler.getInstance().getEntityHelper().setCarryingChest(this.entity.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
    }
}

