/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.UUID;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemSkullskin
implements Property {
    public static final String[] handledTags = new String[]{"skin", "has_skin"};
    public static final String[] handledMechs = new String[]{"skull_skin"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getItemMeta() instanceof SkullMeta;
    }

    public static ItemSkullskin getFrom(ObjectTag _item) {
        if (!ItemSkullskin.describes(_item)) {
            return null;
        }
        return new ItemSkullskin((ItemTag)_item);
    }

    private ItemSkullskin(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("skin")) {
            String skin = this.getPropertyString();
            if (skin != null) {
                if ((attribute = attribute.fulfill(1)).startsWith("full")) {
                    return new ElementTag(skin).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(CoreUtilities.split(skin, '|').get(0)).getAttribute(attribute);
            }
            Debug.echoError("This skull item does not have a skin set!");
        }
        if (attribute.startsWith("has_skin")) {
            return new ElementTag(this.getPropertyString() != null).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public boolean isCorrectDurability() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) || this.item.getItemStack().getDurability() == 3;
    }

    @Override
    public String getPropertyString() {
        PlayerProfile playerProfile;
        if (this.isCorrectDurability() && (playerProfile = NMSHandler.getInstance().getItemHelper().getSkullSkin(this.item.getItemStack())) != null) {
            String name = playerProfile.getName();
            UUID uuid = playerProfile.getUniqueId();
            return (uuid != null ? uuid : name) + (playerProfile.hasTexture() ? "|" + playerProfile.getTexture() + (uuid != null && name != null ? "|" + name : "") : "");
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "skull_skin";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("skull_skin")) {
            PlayerProfile profile;
            if (!this.isCorrectDurability()) {
                this.item.getItemStack().setDurability((short)3);
            }
            ListTag list = mechanism.valueAsType(ListTag.class);
            String idString = (String)list.get(0);
            String texture = null;
            if (list.size() > 1) {
                texture = (String)list.get(1);
            }
            if (idString.contains("-")) {
                UUID uuid = UUID.fromString(idString);
                String name = null;
                if (list.size() > 2) {
                    name = (String)list.get(2);
                }
                profile = new PlayerProfile(name, uuid, texture);
            } else {
                profile = new PlayerProfile(idString, null, texture);
            }
            profile = NMSHandler.getInstance().fillPlayerProfile(profile);
            if (texture != null) {
                profile.setTexture(texture);
            }
            this.item.setItemStack(NMSHandler.getInstance().getItemHelper().setSkullSkin(this.item.getItemStack(), profile));
        }
    }
}

