/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;

public class ItemSpawnEgg
implements Property {
    public static final String[] handledTags = new String[]{"spawn_id", "spawn_egg_entity", "spawn_type"};
    public static final String[] handledMechs = new String[]{"spawn_id", "spawn_egg", "spawn_type"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getItemMeta() instanceof SpawnEggMeta;
    }

    public static ItemSpawnEgg getFrom(ObjectTag _item) {
        if (!ItemSpawnEgg.describes(_item)) {
            return null;
        }
        return new ItemSpawnEgg((ItemTag)_item);
    }

    private ItemSpawnEgg(ItemTag _item) {
        this.item = _item;
    }

    private EntityType getEntityType() {
        return ((SpawnEggMeta)this.item.getItemStack().getItemMeta()).getSpawnedType();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if ((attribute.startsWith("spawn_id") || attribute.startsWith("spawn_egg_entity")) && this.getEntityType() != null) {
            return new ElementTag(this.getEntityType().getTypeId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("spawn_type") && this.getEntityType() != null) {
            return new ElementTag(this.getEntityType().name()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            return null;
        }
        return this.getEntityType() != null ? this.getEntityType().name() : null;
    }

    @Override
    public String getPropertyId() {
        return "spawn_type";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        SpawnEggMeta sem;
        if ((mechanism.matches("spawn_id") || mechanism.matches("spawn_egg")) && mechanism.requireInteger()) {
            sem = (SpawnEggMeta)this.item.getItemStack().getItemMeta();
            sem.setSpawnedType(EntityType.fromId((int)mechanism.getValue().asInt()));
            this.item.getItemStack().setItemMeta((ItemMeta)sem);
        }
        if (mechanism.matches("spawn_type") && mechanism.requireEnum(false, (Enum<?>[])EntityType.values())) {
            try {
                sem = (SpawnEggMeta)this.item.getItemStack().getItemMeta();
                sem.setSpawnedType(EntityType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
                this.item.getItemStack().setItemMeta((ItemMeta)sem);
            }
            catch (IllegalArgumentException e) {
                Debug.echoError(mechanism.getValue().asString().toUpperCase() + " is not a valid spawn egg entity!");
            }
        }
    }
}

