/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class NoteCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("as", "i", "id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (ObjectFetcher.canFetch(arg.getValue().split("@")[0])) {
                scriptEntry.addObject("object", arg.getValue());
                continue;
            }
            if (arg.matches("remove")) {
                scriptEntry.addObject("remove", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an id");
        }
        if (!scriptEntry.hasObject("object") && !scriptEntry.hasObject("remove")) {
            throw new InvalidArgumentsException("Must specify a fetchable-object to note.");
        }
        if (!scriptEntry.hasObject("remove")) {
            scriptEntry.addObject("remove", new ElementTag(false));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String object = (String)scriptEntry.getObject("object");
        ElementTag id = scriptEntry.getElement("id");
        ElementTag remove = scriptEntry.getElement("remove");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("object", object) + id.debug() + remove.debug());
        }
        if (remove.asBoolean()) {
            if (NotableManager.isSaved(id.asString())) {
                NotableManager.remove(id.asString());
                Debug.echoDebug((Debuggable)scriptEntry, "notable '" + id.asString() + "' removed");
            } else {
                Debug.echoDebug((Debuggable)scriptEntry, id.asString() + " is not saved");
            }
            return;
        }
        String object_type = CoreUtilities.toLowerCase(object.split("@")[0]);
        Class object_class = ObjectFetcher.getObjectClass(object_type);
        if (object_class == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Invalid object type! Could not fetch '" + object_type + "'!");
            return;
        }
        try {
            if (!ObjectFetcher.checkMatch(object_class, object)) {
                Debug.echoError(scriptEntry.getResidingQueue(), "'" + object + "' is an invalid " + object_class.getSimpleName() + ".");
                return;
            }
            Object arg = ObjectFetcher.getObjectFrom(object_class, object);
            if (arg instanceof Notable) {
                ((Notable)arg).makeUnique(id.asString());
            }
        }
        catch (Exception e) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Uh oh! Report this to the Denizen developers! Err: NoteCommandObjectReflection");
            Debug.echoError(scriptEntry.getResidingQueue(), e);
        }
    }
}

