/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ScribeCommand
extends AbstractCommand {
    @Override
    public void onEnable() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ScribeCommand.this.paragraph(event);
            }
        }, "p", "n");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesEnum(BookAction.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)BookAction.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class)) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                scriptEntry.addObject("action", (Object)BookAction.DROP);
                continue;
            }
            if (!scriptEntry.hasObject("item") && arg.matchesArgumentType(ItemTag.class)) {
                scriptEntry.addObject("item", arg.asType(ItemTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new Object[]{BookAction.GIVE});
        scriptEntry.defaultObject("item", new ItemTag(Material.WRITTEN_BOOK));
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Missing SCRIPT argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        BookAction action = (BookAction)((Object)scriptEntry.getObject("action"));
        ItemTag book = (ItemTag)scriptEntry.getObject("item");
        ScriptTag script = (ScriptTag)scriptEntry.getObject("script");
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        BookScriptContainer bookScript = (BookScriptContainer)script.getContainer();
        book = bookScript.writeBookTo(book, Utilities.getEntryPlayer(scriptEntry), Utilities.getEntryNPC(scriptEntry));
        switch (action) {
            case DROP: {
                this.dropBook(location, book.getItemStack());
                break;
            }
            case GIVE: {
                this.giveBook(Utilities.getEntryPlayer(scriptEntry).getPlayerEntity(), book.getItemStack());
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().updateInventory();
                break;
            }
            case EQUIP: {
                this.equipBook(Utilities.getEntryPlayer(scriptEntry).getPlayerEntity(), book.getItemStack());
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().updateInventory();
                break;
            }
        }
    }

    private void giveBook(Player player, ItemStack book) {
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (emptySpot != -1) {
            player.getInventory().addItem(new ItemStack[]{book.clone()});
        } else {
            player.getWorld().dropItem(player.getLocation(), book);
            Debug.log("Player's inventory is full, dropped book.");
        }
    }

    private void equipBook(Player player, ItemStack book) {
        ItemStack currItem = player.getItemInHand();
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (currItem == null || currItem.getType() == Material.AIR) {
            player.setItemInHand(book);
            return;
        }
        Debug.log("emptySpot: " + emptySpot);
        if (emptySpot == -1) {
            player.getWorld().dropItem(player.getLocation(), book);
            Debug.log("Player's inventory is full, dropped book.");
        } else {
            inv.setItem(emptySpot, currItem);
            player.setItemInHand(book);
            Debug.log("...added book to player hand, moved original item");
        }
    }

    private void dropBook(Location location, ItemStack book) {
        location.getWorld().dropItem(location, book);
    }

    public void paragraph(ReplaceableTagEvent e) {
        if (e.matches("p")) {
            e.setReplaced("\n \u00a7r \n");
        } else if (e.matches("n")) {
            e.setReplaced("\n");
        }
    }

    private static enum BookAction {
        GIVE,
        DROP,
        EQUIP,
        NONE;

    }
}

