/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.List;

public class KickCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("reason")) {
                scriptEntry.addObject("reason", arg.asElement());
                continue;
            }
            if (!arg.matchesPrefix("targets", "target", "players") && !arg.matchesArgumentList(PlayerTag.class)) continue;
            scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
        }
        scriptEntry.defaultObject("reason", new ElementTag("Kicked."));
        if (!scriptEntry.hasObject("targets")) {
            throw new InvalidArgumentsException("Must specify target(s).");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag reason = scriptEntry.getElement("reason");
        List targets = (List)scriptEntry.getObject("targets");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("targets", targets) + reason.debug());
        }
        for (PlayerTag player : targets) {
            if (!player.isValid() || !player.isOnline()) continue;
            player.getPlayerEntity().kickPlayer(reason.toString());
        }
    }
}

