/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Sound;

public class PlaySoundCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("entities") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("locations", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("entities") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesPrimitive(ArgumentHelper.PrimitiveType.Double) && arg.matchesPrefix("volume, v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesPrimitive(ArgumentHelper.PrimitiveType.Double) && arg.matchesPrefix("pitch, p")) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("sound") && arg.matchesPrimitive(ArgumentHelper.PrimitiveType.String)) {
                scriptEntry.addObject("sound", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("custom") && arg.matches("custom")) {
                scriptEntry.addObject("custom", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("sound_category") && arg.matchesOnePrefix("sound_category")) {
                scriptEntry.addObject("sound_category", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("sound")) {
            throw new InvalidArgumentsException("Missing sound argument!");
        }
        if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        scriptEntry.defaultObject("volume", new ElementTag(1));
        scriptEntry.defaultObject("pitch", new ElementTag(1));
        scriptEntry.defaultObject("custom", new ElementTag(false));
        scriptEntry.defaultObject("sound_category", new ElementTag("MASTER"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List locations = (List)scriptEntry.getObject("locations");
        List players = (List)scriptEntry.getObject("entities");
        ElementTag sound = scriptEntry.getElement("sound");
        ElementTag volume = scriptEntry.getElement("volume");
        ElementTag pitch = scriptEntry.getElement("pitch");
        ElementTag custom = scriptEntry.getElement("custom");
        ElementTag sound_category = scriptEntry.getElement("sound_category");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (locations != null ? ArgumentHelper.debugObj("locations", locations.toString()) : "") + (players != null ? ArgumentHelper.debugObj("entities", players.toString()) : "") + sound.debug() + volume.debug() + pitch.debug() + custom.debug());
        }
        try {
            if (locations != null) {
                if (custom.asBoolean()) {
                    for (LocationTag location : locations) {
                        NMSHandler.getInstance().getSoundHelper().playSound(null, (Location)location, sound.asString(), volume.asFloat(), pitch.asFloat(), sound_category.asString());
                    }
                } else {
                    for (LocationTag location : locations) {
                        NMSHandler.getInstance().getSoundHelper().playSound(null, (Location)location, Sound.valueOf((String)sound.asString().toUpperCase()), volume.asFloat(), pitch.asFloat(), sound_category.asString());
                    }
                }
            } else {
                for (PlayerTag player : players) {
                    if (custom.asBoolean()) {
                        NMSHandler.getInstance().getSoundHelper().playSound(player.getPlayerEntity(), (Location)player.getLocation(), sound.asString(), volume.asFloat(), pitch.asFloat(), sound_category.asString());
                        continue;
                    }
                    NMSHandler.getInstance().getSoundHelper().playSound(player.getPlayerEntity(), (Location)player.getLocation(), Sound.valueOf((String)sound.asString().toUpperCase()), volume.asFloat(), pitch.asFloat(), sound_category.asString());
                }
            }
        }
        catch (Exception e) {
            Debug.echoDebug((Debuggable)scriptEntry, "Unable to play sound.");
        }
    }
}

