/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.DenizenAliasHelpTopic;
import com.denizenscript.denizen.utilities.DenizenCommand;
import com.denizenscript.denizen.utilities.DenizenCommandHelpTopic;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.defaults.HelpCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CommandScriptHelper
implements Listener {
    public static Map<String, DenizenCommand> denizenCommands = new ConcurrentHashMap<String, DenizenCommand>(8, 0.9f, 1);
    public static Map<String, Command> overriddenCommands = new HashMap<String, Command>();
    public static Map<String, HelpTopic> overriddenHelpTopics = new HashMap<String, HelpTopic>();
    public static Map<String, Command> knownCommands = null;
    public static Map<String, HelpTopic> helpTopics = null;
    public static boolean hasCommandInformation = true;
    public static final Method syncCommandsMethod;

    public CommandScriptHelper() {
        try {
            Server server = Bukkit.getServer();
            server.getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
            Field commandMapField = server.getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(server);
            Field kcf = null;
            Class<?> commandMapClass = commandMap.getClass();
            while (kcf == null && commandMapClass != Object.class) {
                try {
                    kcf = commandMapClass.getDeclaredField("knownCommands");
                }
                catch (NoSuchFieldException e) {
                    commandMapClass = commandMapClass.getSuperclass();
                }
            }
            Field knownCommandsField = kcf;
            knownCommandsField.setAccessible(true);
            knownCommands = (Map)knownCommandsField.get(commandMap);
            HelpMap helpMap = server.getHelpMap();
            Field helpTopicsField = helpMap.getClass().getDeclaredField("helpTopics");
            helpTopicsField.setAccessible(true);
            helpTopics = (Map)helpTopicsField.get(helpMap);
            if (Settings.overrideHelp()) {
                new BukkitRunnable(){

                    public void run() {
                        if (knownCommands.get("help") instanceof HelpCommand) {
                            return;
                        }
                        knownCommands.put("help", knownCommands.get("bukkit:help"));
                        helpTopics.put("/help", helpTopics.get("/bukkit:help"));
                    }
                }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
            }
        }
        catch (Exception e) {
            Debug.echoError("Error getting the server's command information! Are you running a non-CraftBukkit server?");
            Debug.echoError("Command scripts will not function!");
            hasCommandInformation = false;
        }
    }

    @EventHandler
    public void scriptReload(ScriptReloadEvent event) {
        CommandScriptHelper.syncDenizenCommands();
    }

    public static void syncDenizenCommands() {
        if (syncCommandsMethod != null) {
            try {
                syncCommandsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            }
            catch (Exception e) {
                Debug.echoError("Failed to synchronize server commands.");
            }
        }
    }

    public static void removeDenizenCommands() {
        if (!hasCommandInformation) {
            return;
        }
        for (String command : denizenCommands.keySet()) {
            knownCommands.remove(command);
            helpTopics.remove(command);
            if (!overriddenCommands.containsKey(command)) continue;
            knownCommands.put(command, overriddenCommands.get(command));
            if (!overriddenHelpTopics.containsKey(command)) continue;
            helpTopics.put(command, overriddenHelpTopics.get(command));
        }
        denizenCommands.clear();
    }

    public static void registerDenizenCommand(DenizenCommand command) {
        if (!hasCommandInformation) {
            return;
        }
        String name = command.getName();
        if (!denizenCommands.containsKey(name)) {
            CommandScriptHelper.forceCommand(name, command, (HelpTopic)new DenizenCommandHelpTopic(command));
            for (String alias : command.getAliases()) {
                if (denizenCommands.containsKey(alias)) continue;
                CommandScriptHelper.forceCommand(alias, command, new DenizenAliasHelpTopic("/" + alias, name, DenizenAPI.getCurrentInstance().getServer().getHelpMap()));
            }
        }
    }

    private static void forceCommand(String name, DenizenCommand command, HelpTopic helpTopic) {
        if (knownCommands.containsKey(name)) {
            overriddenCommands.put(name, knownCommands.get(name));
            knownCommands.remove(name);
            if (helpTopics.containsKey(name)) {
                overriddenHelpTopics.put(name, helpTopics.get(name));
                helpTopics.remove(name);
            }
        }
        knownCommands.put(name, command);
        helpTopics.put(helpTopic.getName(), helpTopic);
        denizenCommands.put(name, command);
    }

    static {
        Method syncMethod = null;
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            try {
                syncMethod = Bukkit.getServer().getClass().getDeclaredMethod("syncCommands", new Class[0]);
                syncMethod.setAccessible(true);
            }
            catch (Exception e) {
                Debug.echoError("Failed to load helper to synchronize server commands.");
            }
        }
        syncCommandsMethod = syncMethod;
    }

    private static class IsCommandTopicPredicate
    implements Predicate<HelpTopic> {
        private IsCommandTopicPredicate() {
        }

        public boolean test(HelpTopic topic) {
            return this.apply(topic);
        }

        public boolean apply(HelpTopic topic) {
            return topic.getName().charAt(0) == '/';
        }
    }
}

