/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;

public class LocationTagBase {
    public SlowWarning locationShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'location' instead of 'l' as a root tag.");

    public LocationTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                LocationTagBase.this.locationTags(event);
            }
        }, "location", "l");
    }

    public void locationTags(ReplaceableTagEvent event) {
        if (!event.matches("location", "l") || event.replaced()) {
            return;
        }
        if (event.matches("l")) {
            this.locationShorthand.warn(event.getScriptEntry());
        }
        LocationTag loc = null;
        String context = event.getNameContext();
        if (event.hasNameContext() && LocationTag.matches(context)) {
            loc = LocationTag.valueOf(context, event.getAttributes().context);
        } else if (event.getScriptEntry().hasObject("location")) {
            loc = (LocationTag)event.getScriptEntry().getObject("location");
        }
        if (loc == null) {
            return;
        }
        event.setReplacedObject(CoreUtilities.autoAttrib(loc, event.getAttributes().fulfill(1)));
    }
}

