/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.scripts.commands.server.BossBarCommand;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.core.SQLCommand;
import com.denizenscript.denizencore.scripts.containers.core.WorldScriptContainer;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.javaluator.DoubleEvaluator;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCursor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ServerTagBase {
    public SlowWarning serverShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'server' instead of 'svr' as a root tag.");

    public ServerTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ServerTagBase.this.mathTag(event);
            }
        }, "math", "m");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ServerTagBase.this.serverTag(event);
            }
        }, "server", "svr", "global");
    }

    public void mathTag(ReplaceableTagEvent event) {
        if (!event.matches("math", "m")) {
            return;
        }
        Debug.echoError("'math:' tags have been non-recommended for years. Please use modern element math tags like 'element.add[...]', etc.");
        try {
            Double evaluation = (Double)new DoubleEvaluator().evaluate(event.getValue());
            event.setReplaced(new ElementTag(String.valueOf(evaluation)).getAttribute(event.getAttributes().fulfill(1)));
        }
        catch (Exception e) {
            Debug.echoError("Invalid math tag!");
            event.setReplaced("0.0");
        }
    }

    public void serverTag(ReplaceableTagEvent event) {
        block216: {
            BanEntry ban;
            ListTag players;
            String flag;
            Object npcs;
            String matchInput;
            Object matchPlayer;
            ListTag plugins;
            Object world;
            String group;
            ListTag list;
            Object npc;
            String eventName;
            String flag_name;
            Attribute attribute;
            if (!event.matches("server", "svr", "global") || event.replaced()) {
                return;
            }
            if (event.matches("srv")) {
                this.serverShorthand.warn(event.getScriptEntry());
            }
            if (event.matches("global")) {
                Debug.echoError(event.getScriptEntry() == null ? null : event.getScriptEntry().getResidingQueue(), "Using 'global' as a base tag is a deprecated alternate name. Please use 'server' instead.");
            }
            if ((attribute = event.getAttributes().fulfill(1)).startsWith("economy")) {
                if (Depends.economy == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    }
                    return;
                }
                if ((attribute = attribute.fulfill(1)).startsWith("format") && attribute.hasContext(1)) {
                    double amount = attribute.getDoubleContext(1);
                    event.setReplacedObject(new ElementTag(Depends.economy.format(amount)).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_name") && attribute.hasContext(1)) {
                    double amount = attribute.getDoubleContext(1);
                    event.setReplacedObject(new ElementTag(amount == 1.0 ? Depends.economy.currencyNameSingular() : Depends.economy.currencyNamePlural()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_plural")) {
                    event.setReplacedObject(new ElementTag(Depends.economy.currencyNamePlural()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_singular")) {
                    event.setReplacedObject(new ElementTag(Depends.economy.currencyNameSingular()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                return;
            }
            if (attribute.startsWith("slot_id") && attribute.hasContext(1)) {
                int slotId = SlotHelper.nameToIndex(attribute.getContext(1));
                if (slotId != -1) {
                    event.setReplaced(new ElementTag(slotId).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("parse_bukkit_item") && attribute.hasContext(1)) {
                YamlConfiguration config = new YamlConfiguration();
                try {
                    config.loadFromString(attribute.getContext(1));
                    ItemStack item = config.getItemStack("item");
                    if (item != null) {
                        event.setReplaced(new ItemTag(item).getAttribute(attribute.fulfill(1)));
                    }
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                }
                return;
            }
            if (attribute.startsWith("list_commands")) {
                ListTag list2 = new ListTag();
                for (String string : CommandScriptHelper.knownCommands.keySet()) {
                    list2.add(string);
                }
                event.setReplaced(list2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("scoreboard")) {
                Scoreboard board;
                String name = "main";
                if (attribute.hasContext(1)) {
                    name = attribute.getContext(1);
                    board = ScoreboardHelper.getScoreboard(name);
                } else {
                    board = ScoreboardHelper.getMain();
                }
                attribute = attribute.fulfill(1);
                if (attribute.startsWith("exists")) {
                    event.setReplaced(new ElementTag(board != null).getAttribute(attribute.fulfill(1)));
                    return;
                }
                if (board == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Scoreboard '" + name + "' does not exist.");
                    }
                    return;
                }
                if (attribute.startsWith("team") && attribute.hasContext(1)) {
                    Team team = board.getTeam(attribute.getContext(1));
                    if (team == null) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Scoreboard team '" + attribute.getContext(1) + "' does not exist.");
                        }
                        return;
                    }
                    if ((attribute = attribute.fulfill(1)).startsWith("members")) {
                        event.setReplacedObject(new ListTag(team.getEntries()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    return;
                }
            }
            if (attribute.startsWith("object_is_valid")) {
                ObjectTag o = ObjectFetcher.pickObjectFor(attribute.getContext(1), new BukkitTagContext(null, null, false, null, false, null));
                event.setReplaced(new ElementTag(o != null && !(o instanceof ElementTag)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_whitelist")) {
                event.setReplaced(new ElementTag(Bukkit.hasWhitelist()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_flag")) {
                if (!attribute.hasContext(1)) {
                    event.setReplaced("null");
                    return;
                }
                flag_name = attribute.getContext(1);
                event.setReplaced(new ElementTag(FlagManager.serverHasFlag(flag_name)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("flag")) {
                if (!attribute.hasContext(1)) {
                    event.setReplaced("null");
                    return;
                }
                flag_name = attribute.getContext(1);
                attribute.fulfill(1);
                if (attribute.startsWith("is_expired") || attribute.startsWith("isexpired")) {
                    event.setReplaced(new ElementTag(!FlagManager.serverHasFlag(flag_name)).getAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("size") && !FlagManager.serverHasFlag(flag_name)) {
                    event.setReplaced(new ElementTag(0).getAttribute(attribute.fulfill(1)));
                    return;
                }
                if (FlagManager.serverHasFlag(flag_name)) {
                    FlagManager.Flag flag2 = DenizenAPI.getCurrentInstance().flagManager().getGlobalFlag(flag_name);
                    event.setReplaced(new ListTag(flag2.toString(), true, flag2.values()).getAttribute(attribute));
                }
                return;
            }
            if (attribute.startsWith("list_biomes")) {
                ListTag allBiomes = new ListTag();
                for (Biome biome : Biome.values()) {
                    allBiomes.add(biome.name());
                }
                event.setReplaced(allBiomes.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_enchantments")) {
                ListTag enchants = new ListTag();
                for (Biome biome : Enchantment.values()) {
                    enchants.add(biome.getName());
                }
                event.setReplaced(enchants.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_entity_types")) {
                ListTag allEnt = new ListTag();
                for (Biome biome : EntityType.values()) {
                    allEnt.add(biome.name());
                }
                event.setReplaced(allEnt.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_materials")) {
                ListTag allMats = new ListTag();
                for (Biome biome : Material.values()) {
                    allMats.add(biome.name());
                }
                event.setReplaced(allMats.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_sounds")) {
                ListTag sounds = new ListTag();
                for (Biome biome : Sound.values()) {
                    sounds.add(biome.toString());
                }
                event.setReplaced(sounds.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_patterns")) {
                ListTag allPatterns = new ListTag();
                for (PatternType patternType : PatternType.values()) {
                    allPatterns.add(patternType.toString());
                }
                event.setReplaced(allPatterns.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_potion_effects")) {
                ListTag statuses = new ListTag();
                for (PotionEffectType potionEffectType : PotionEffectType.values()) {
                    if (potionEffectType == null) continue;
                    statuses.add(potionEffectType.getName());
                }
                event.setReplaced(statuses.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_potion_types")) {
                ListTag potionTypes = new ListTag();
                for (PotionType potionType : PotionType.values()) {
                    potionTypes.add(potionType.toString());
                }
                event.setReplaced(potionTypes.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_tree_types")) {
                ListTag allTrees = new ListTag();
                for (TreeType treeType : TreeType.values()) {
                    allTrees.add(treeType.name());
                }
                event.setReplaced(allTrees.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_map_cursor_types")) {
                ListTag mapCursors = new ListTag();
                for (MapCursor.Type type : MapCursor.Type.values()) {
                    mapCursors.add(type.toString());
                }
                event.setReplaced(mapCursors.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_world_types")) {
                ListTag worldTypes = new ListTag();
                for (WorldType worldType : WorldType.values()) {
                    worldTypes.add(worldType.toString());
                }
                event.setReplaced(worldTypes.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_flags")) {
                ListTag allFlags = new ListTag(DenizenAPI.getCurrentInstance().flagManager().listGlobalFlags());
                ListTag searchFlags = null;
                if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                    searchFlags = new ListTag();
                    String string = attribute.getContext(1);
                    if (string.startsWith("regex:")) {
                        try {
                            Pattern pattern = Pattern.compile(string.substring(6), 2);
                            for (String flag3 : allFlags) {
                                if (!pattern.matcher(flag3).matches()) continue;
                                searchFlags.add(flag3);
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                        }
                    } else {
                        String string2 = CoreUtilities.toLowerCase(string);
                        for (String string3 : allFlags) {
                            if (!CoreUtilities.toLowerCase(string3).contains(string2)) continue;
                            searchFlags.add(string3);
                        }
                    }
                    DenizenAPI.getCurrentInstance().flagManager().shrinkGlobalFlags(searchFlags);
                } else {
                    DenizenAPI.getCurrentInstance().flagManager().shrinkGlobalFlags(allFlags);
                }
                event.setReplaced(searchFlags == null ? allFlags.getAttribute(attribute.fulfill(1)) : searchFlags.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_notables")) {
                ListTag allNotables = new ListTag();
                if (attribute.hasContext(1)) {
                    String type = CoreUtilities.toLowerCase(attribute.getContext(1));
                    for (Map.Entry<String, Class> typeClass : NotableManager.getReverseClassIdMap().entrySet()) {
                        if (!type.equals(CoreUtilities.toLowerCase(typeClass.getKey()))) continue;
                        for (Object notable : NotableManager.getAllType(typeClass.getValue())) {
                            allNotables.add(((ObjectTag)notable).identify());
                        }
                        break;
                    }
                } else {
                    for (Notable notable : NotableManager.notableObjects.values()) {
                        allNotables.add(((ObjectTag)((Object)notable)).identify());
                    }
                }
                event.setReplaced(allNotables.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("start_time")) {
                event.setReplaced(new DurationTag(Denizen.startTime / 50L).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_allocated")) {
                event.setReplaced(new ElementTag(Runtime.getRuntime().totalMemory()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_max")) {
                event.setReplaced(new ElementTag(Runtime.getRuntime().maxMemory()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_free")) {
                event.setReplaced(new ElementTag(Runtime.getRuntime().freeMemory()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_usage")) {
                event.setReplaced(new ElementTag(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("available_processors")) {
                event.setReplaced(new ElementTag(Runtime.getRuntime().availableProcessors()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("current_time_millis")) {
                event.setReplaced(new ElementTag(System.currentTimeMillis()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("has_event") && attribute.hasContext(1)) {
                event.setReplaced(new ElementTag(OldEventManager.eventExists(attribute.getContext(1)) || OldEventManager.eventExists(OldEventManager.StripIdentifiers(attribute.getContext(1)))).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("event_handlers") && attribute.hasContext(1)) {
                eventName = attribute.getContext(1).toUpperCase();
                List<WorldScriptContainer> EventsOne = OldEventManager.events.get("ON " + eventName);
                List<WorldScriptContainer> list2 = OldEventManager.events.get("ON " + OldEventManager.StripIdentifiers(eventName));
                if (EventsOne == null && list2 == null) {
                    Debug.echoError("No world scripts will handle the event '" + eventName + "'");
                } else {
                    ListTag list3 = new ListTag();
                    if (EventsOne != null) {
                        Iterator iterator = EventsOne.iterator();
                        while (iterator.hasNext()) {
                            WorldScriptContainer script = (WorldScriptContainer)iterator.next();
                            list3.add("s@" + script.getName());
                        }
                    }
                    if (list2 != null) {
                        for (WorldScriptContainer script : list2) {
                            if (list3.contains("s@" + script.getName())) continue;
                            list3.add("s@" + script.getName());
                        }
                    }
                    event.setReplaced(list3.getAttribute(attribute.fulfill(1)));
                }
            }
            if (attribute.startsWith("selected_npc")) {
                npc = ((Citizens)Bukkit.getPluginManager().getPlugin("Citizens")).getNPCSelector().getSelected((CommandSender)Bukkit.getConsoleSender());
                if (npc == null) {
                    return;
                }
                event.setReplaced(new NPCTag((NPC)npc).getAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("list_npcs_named") || attribute.startsWith("get_npcs_named")) && Depends.citizens != null && attribute.hasContext(1)) {
                ListTag npcs2 = new ListTag();
                for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                    if (!nPC.getName().equalsIgnoreCase(attribute.getContext(1))) continue;
                    npcs2.add(NPCTag.mirrorCitizensNPC(nPC).identify());
                }
                event.setReplaced(npcs2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_file") && attribute.hasContext(1)) {
                File f = new File(DenizenAPI.getCurrentInstance().getDataFolder(), attribute.getContext(1));
                try {
                    if (!Utilities.canReadFile(f)) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Invalid path specified. Invalid paths have been denied by the server administrator.");
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    Debug.echoError(e);
                    return;
                }
                event.setReplaced(new ElementTag(f.exists()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_files") && attribute.hasContext(1)) {
                File folder = new File(DenizenAPI.getCurrentInstance().getDataFolder(), attribute.getContext(1));
                try {
                    if (!Utilities.canReadFile(folder)) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Invalid path specified. Invalid paths have been denied by the server administrator.");
                        }
                        return;
                    }
                    if (!folder.exists() || !folder.isDirectory()) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("Invalid path specified. No directory exists at that path.");
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    Debug.echoError(e);
                    return;
                }
                File[] files = folder.listFiles();
                if (files == null) {
                    return;
                }
                ListTag listTag = new ListTag();
                for (File file : files) {
                    listTag.add(file.getName());
                }
                event.setReplaced(listTag.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_permissions")) {
                event.setReplaced(new ElementTag(Depends.permissions != null && Depends.permissions.isEnabled()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_economy")) {
                event.setReplaced(new ElementTag(Depends.economy != null && Depends.economy.isEnabled()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("denizen_version")) {
                event.setReplaced(new ElementTag(DenizenAPI.getCurrentInstance().getDescription().getVersion()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("bukkit_version")) {
                event.setReplaced(new ElementTag(Bukkit.getBukkitVersion()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("version")) {
                event.setReplaced(new ElementTag(Bukkit.getServer().getVersion()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("java_version")) {
                event.setReplaced(new ElementTag(System.getProperty("java.version")).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("max_players")) {
                event.setReplaced(new ElementTag(Bukkit.getServer().getMaxPlayers()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_sql_connections")) {
                list = new ListTag();
                for (Map.Entry entry : SQLCommand.connections.entrySet()) {
                    try {
                        if (!((Connection)entry.getValue()).isClosed()) {
                            list.add((String)entry.getKey());
                            continue;
                        }
                        SQLCommand.connections.remove(entry.getKey());
                    }
                    catch (SQLException e) {
                        Debug.echoError(attribute.getScriptEntry().getResidingQueue(), e);
                    }
                }
                event.setReplaced(list.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("group_prefix")) {
                if (Depends.permissions == null) {
                    Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                group = attribute.getContext(1);
                if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                    Debug.echoError("Invalid group! '" + (group != null ? group : "") + "' could not be found.");
                    return;
                }
                if (attribute.getAttribute(2).startsWith("world")) {
                    world = WorldTag.valueOf(attribute.getContext(2));
                    if (world != null) {
                        event.setReplaced(new ElementTag(Depends.chat.getGroupPrefix(((WorldTag)world).getWorld(), group)).getAttribute(attribute.fulfill(2)));
                    }
                    return;
                }
                event.setReplaced(new ElementTag(Depends.chat.getGroupPrefix((World)Bukkit.getWorlds().get(0), group)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("group_suffix")) {
                if (Depends.permissions == null) {
                    Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                group = attribute.getContext(1);
                if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                    Debug.echoError("Invalid group! '" + (group != null ? group : "") + "' could not be found.");
                    return;
                }
                if (attribute.getAttribute(2).startsWith("world")) {
                    world = WorldTag.valueOf(attribute.getContext(2));
                    if (world != null) {
                        event.setReplaced(new ElementTag(Depends.chat.getGroupSuffix(((WorldTag)world).getWorld(), group)).getAttribute(attribute.fulfill(2)));
                    }
                    return;
                }
                event.setReplaced(new ElementTag(Depends.chat.getGroupSuffix((World)Bukkit.getWorlds().get(0), group)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_permission_groups")) {
                if (Depends.permissions == null) {
                    Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                event.setReplaced(new ListTag(Arrays.asList(Depends.permissions.getGroups())).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_plugin_names")) {
                plugins = new ListTag();
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    plugins.add(plugin.getName());
                }
                event.setReplaced(plugins.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_scripts")) {
                ListTag scripts = new ListTag();
                for (String string : ScriptRegistry._getScriptNames()) {
                    scripts.add("s@" + string);
                }
                event.setReplaced(scripts.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("match_player") && attribute.hasContext(1)) {
                matchPlayer = null;
                matchInput = CoreUtilities.toLowerCase(attribute.getContext(1));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (CoreUtilities.toLowerCase(player.getName()).equals(matchInput)) {
                        matchPlayer = player;
                        break;
                    }
                    if (!CoreUtilities.toLowerCase(player.getName()).contains(matchInput) || matchPlayer != null) continue;
                    matchPlayer = player;
                }
                if (matchPlayer != null) {
                    event.setReplaced(new PlayerTag((Player)matchPlayer).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("match_offline_player") && attribute.hasContext(1)) {
                matchPlayer = null;
                matchInput = CoreUtilities.toLowerCase(attribute.getContext(1));
                for (Map.Entry<String, UUID> entry : PlayerTag.getAllPlayers().entrySet()) {
                    if (CoreUtilities.toLowerCase(entry.getKey()).equals(matchInput)) {
                        matchPlayer = entry.getValue();
                        break;
                    }
                    if (!CoreUtilities.toLowerCase(entry.getKey()).contains(matchInput) || matchPlayer != null) continue;
                    matchPlayer = entry.getValue();
                }
                if (matchPlayer != null) {
                    event.setReplaced(new PlayerTag((UUID)matchPlayer).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if ((attribute.startsWith("list_npcs_assigned") || attribute.startsWith("get_npcs_assigned")) && Depends.citizens != null && attribute.hasContext(1)) {
                ScriptTag script = ScriptTag.valueOf(attribute.getContext(1));
                if (script == null || !(script.getContainer() instanceof AssignmentScriptContainer)) {
                    Debug.echoError("Invalid script specified.");
                } else {
                    npcs = new ListTag();
                    for (NPC npc3 : CitizensAPI.getNPCRegistry()) {
                        if (!npc3.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)npc3.getTrait(AssignmentTrait.class)).hasAssignment() || !((AssignmentTrait)npc3.getTrait(AssignmentTrait.class)).getAssignment().getName().equalsIgnoreCase(script.getName())) continue;
                        ((ListTag)npcs).add(NPCTag.mirrorCitizensNPC(npc3).identify());
                    }
                    event.setReplaced(((ListTag)npcs).getAttribute(attribute.fulfill(1)));
                    return;
                }
            }
            if ((attribute.startsWith("list_online_players_flagged") || attribute.startsWith("get_online_players_flagged")) && attribute.hasContext(1)) {
                flag = attribute.getContext(1);
                ListTag players2 = new ListTag();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(new PlayerTag(player), flag).size() <= 0) continue;
                    players2.add(new PlayerTag(player).identify());
                }
                event.setReplaced(players2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("list_players_flagged") || attribute.startsWith("get_players_flagged")) && attribute.hasContext(1)) {
                flag = attribute.getContext(1);
                ListTag players2 = new ListTag();
                for (Map.Entry<String, UUID> entry : PlayerTag.getAllPlayers().entrySet()) {
                    if (DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(new PlayerTag(entry.getValue()), flag).size() <= 0) continue;
                    players2.add(new PlayerTag(entry.getValue()).identify());
                }
                event.setReplaced(players2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("list_spawned_npcs_flagged") || attribute.startsWith("get_spawned_npcs_flagged")) && Depends.citizens != null && attribute.hasContext(1)) {
                flag = attribute.getContext(1);
                npcs = new ListTag();
                for (NPC npc4 : CitizensAPI.getNPCRegistry()) {
                    NPCTag nPCTag = NPCTag.mirrorCitizensNPC(npc4);
                    if (!nPCTag.isSpawned() || !FlagManager.npcHasFlag(nPCTag, flag)) continue;
                    ((ListTag)npcs).add(nPCTag.identify());
                }
                event.setReplaced(((ListTag)npcs).getAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("list_npcs_flagged") || attribute.startsWith("get_npcs_flagged")) && Depends.citizens != null && attribute.hasContext(1)) {
                flag = attribute.getContext(1);
                npcs = new ListTag();
                for (NPC npc5 : CitizensAPI.getNPCRegistry()) {
                    NPCTag nPCTag = NPCTag.mirrorCitizensNPC(npc5);
                    if (!FlagManager.npcHasFlag(nPCTag, flag)) continue;
                    ((ListTag)npcs).add(nPCTag.identify());
                }
                event.setReplaced(((ListTag)npcs).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_npcs") && Depends.citizens != null) {
                ListTag npcs2 = new ListTag();
                for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                    npcs2.add(NPCTag.mirrorCitizensNPC(nPC).identify());
                }
                event.setReplaced(npcs2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_worlds")) {
                ListTag worlds = new ListTag();
                for (World world2 : Bukkit.getWorlds()) {
                    worlds.add(WorldTag.mirrorBukkitWorld(world2).identify());
                }
                event.setReplaced(worlds.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_plugins")) {
                plugins = new ListTag();
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    plugins.add(new PluginTag(plugin).identify());
                }
                event.setReplaced(plugins.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_players")) {
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    players.add(PlayerTag.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_online_players")) {
                players = new ListTag();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    players.add(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_offline_players")) {
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (offlinePlayer.isOnline()) continue;
                    players.add(PlayerTag.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_banned_players")) {
                ListTag banned = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getBannedPlayers()) {
                    banned.add(PlayerTag.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(banned.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_banned_addresses")) {
                list = new ListTag();
                list.addAll(Bukkit.getIPBans());
                event.setReplaced(list.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("is_banned") && attribute.hasContext(1)) {
                ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(attribute.getContext(1));
                if (ban == null) {
                    event.setReplaced(new ElementTag(false).getAttribute(attribute.fulfill(1)));
                } else if (ban.getExpiration() == null) {
                    event.setReplaced(new ElementTag(true).getAttribute(attribute.fulfill(1)));
                } else {
                    event.setReplaced(new ElementTag(ban.getExpiration().after(new Date())).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("ban_info") && attribute.hasContext(1)) {
                ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(attribute.getContext(1));
                attribute.fulfill(1);
                if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                    return;
                }
                if (attribute.startsWith("expiration") && ban.getExpiration() != null) {
                    event.setReplaced(new DurationTag(ban.getExpiration().getTime() / 50L).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("reason")) {
                    event.setReplaced(new ElementTag(ban.getReason()).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("created")) {
                    event.setReplaced(new DurationTag(ban.getCreated().getTime() / 50L).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("source")) {
                    event.setReplaced(new ElementTag(ban.getSource()).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("list_ops")) {
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOperators()) {
                    players.add(PlayerTag.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_online_ops")) {
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOperators()) {
                    if (!offlinePlayer.isOnline()) continue;
                    players.add(PlayerTag.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_offline_ops")) {
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (!offlinePlayer.isOp() || offlinePlayer.isOnline()) continue;
                    players.add(PlayerTag.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("motd")) {
                event.setReplaced(new ElementTag(Bukkit.getServer().getMotd()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("entity_is_spawned") && attribute.hasContext(1)) {
                EntityTag ent = EntityTag.valueOf(attribute.getContext(1), new BukkitTagContext(null, null, false, null, false, null));
                event.setReplaced(new ElementTag(ent != null && ent.isUnique() && ent.isSpawned() ? "true" : "false").getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("player_is_valid") && attribute.hasContext(1)) {
                event.setReplaced(new ElementTag(PlayerTag.playerNameIsValid(attribute.getContext(1))).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("npc_is_valid") && attribute.hasContext(1)) {
                npc = NPCTag.valueOf(attribute.getContext(1), new BukkitTagContext(null, null, false, null, false, null));
                event.setReplaced(new ElementTag(npc != null && ((NPCTag)npc).isValid()).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("current_bossbars")) {
                ListTag dl = new ListTag();
                for (String string : BossBarCommand.bossBarMap.keySet()) {
                    dl.add(string);
                }
                event.setReplaced(dl.getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("recent_tps")) {
                list = new ListTag();
                for (Object object : (Object)NMSHandler.getInstance().getRecentTps()) {
                    list.add(new ElementTag((double)object).identify());
                }
                event.setReplaced(list.getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("port")) {
                event.setReplaced(new ElementTag(NMSHandler.getInstance().getPort()).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("debug_enabled")) {
                event.setReplaced(new ElementTag(Debug.showDebug).getAttribute(attribute.fulfill(1)));
            } else if (attribute.matches("list_plugins_handling_event") && attribute.hasContext(1)) {
                eventName = attribute.getContext(1);
                if (eventName.contains(".")) {
                    try {
                        Class<?> clazz = Class.forName(eventName, false, ServerTagBase.class.getClassLoader());
                        ListTag listTag = ServerTagBase.getHandlerPluginList(clazz);
                        if (listTag != null) {
                            event.setReplaced(listTag.getAttribute(attribute.fulfill(1)));
                        }
                        break block216;
                    }
                    catch (ClassNotFoundException ex) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError(ex);
                        }
                        break block216;
                    }
                }
                ScriptEvent scriptEvent = ScriptEvent.eventLookup.get(CoreUtilities.toLowerCase(eventName));
                if (scriptEvent instanceof Listener) {
                    Denizen denizen = DenizenAPI.getCurrentInstance();
                    for (Class clazz : denizen.getPluginLoader().createRegisteredListeners((Listener)scriptEvent, (Plugin)denizen).keySet()) {
                        ListTag result = ServerTagBase.getHandlerPluginList(clazz);
                        if (result == null || result.size() <= 0) continue;
                        event.setReplaced(result.getAttribute(attribute.fulfill(1)));
                        return;
                    }
                    event.setReplaced(new ListTag().getAttribute(attribute.fulfill(1)));
                }
            }
        }
    }

    public static ListTag getHandlerPluginList(Class eventClass) {
        HandlerList handlers;
        if (Event.class.isAssignableFrom(eventClass) && (handlers = BukkitScriptEvent.getEventListeners(eventClass)) != null) {
            ListTag result = new ListTag();
            HashSet<String> deduplicationSet = new HashSet<String>();
            for (RegisteredListener listener : handlers.getRegisteredListeners()) {
                if (!deduplicationSet.add(listener.getPlugin().getName())) continue;
                result.addObject(new PluginTag(listener.getPlugin()));
            }
            return result;
        }
        return null;
    }

    public static void adjustServer(Mechanism mechanism) {
        if (mechanism.matches("delete_file") && mechanism.hasValue()) {
            if (!Settings.allowDelete()) {
                Debug.echoError("File deletion disabled by administrator.");
                return;
            }
            File file = new File(DenizenAPI.getCurrentInstance().getDataFolder(), mechanism.getValue().asString());
            if (!Utilities.canWriteToFile(file)) {
                Debug.echoError("Cannot delete that file (unsafe path).");
                return;
            }
            try {
                if (!file.delete()) {
                    Debug.echoError("Failed to delete file: returned false");
                }
            }
            catch (Exception e) {
                Debug.echoError("Failed to delete file: " + e.getMessage());
            }
        }
        if (mechanism.matches("redirect_logging") && mechanism.hasValue()) {
            if (!Settings.allowConsoleRedirection()) {
                Debug.echoError("Console redirection disabled by administrator.");
                return;
            }
            if (mechanism.getValue().asBoolean()) {
                DenizenCore.logInterceptor.redirectOutput();
            } else {
                DenizenCore.logInterceptor.standardOutput();
            }
        }
        if (mechanism.matches("reset_event_stats")) {
            for (ScriptEvent se : ScriptEvent.events) {
                se.stats.fires = 0L;
                se.stats.scriptFires = 0L;
                se.stats.nanoTimes = 0L;
            }
        }
        if (mechanism.matches("cleanmem")) {
            System.gc();
        }
        if (mechanism.matches("restart")) {
            if (!Settings.allowServerRestart()) {
                Debug.echoError("Server restart disabled by administrator. Consider using 'shutdown'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server restarted by a Denizen script, see config to prevent this!");
            Bukkit.spigot().restart();
        }
        if (mechanism.matches("save")) {
            DenizenAPI.getCurrentInstance().saveSaves();
        }
        if (Depends.citizens != null && mechanism.matches("save_citizens")) {
            Depends.citizens.storeNPCs(new CommandContext(new String[0]));
        }
        if (mechanism.matches("shutdown")) {
            if (!Settings.allowServerStop()) {
                Debug.echoError("Server stop disabled by administrator. Consider using 'restart'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server shutdown by a Denizen script, see config to prevent this!");
            Bukkit.shutdown();
        }
    }
}

