/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.inventory;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.inventory.InventoryMenu;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public abstract class InventoryMenuItem {
    protected InventoryMenu menu;
    protected int index;
    protected ItemStack item;

    public InventoryMenuItem(ItemStack item) {
        this.item = item;
    }

    public InventoryMenuItem(String text) {
        this(text, new MaterialData(Material.PAPER));
    }

    public InventoryMenuItem(String text, MaterialData icon) {
        this(text, icon, 1);
    }

    public InventoryMenuItem(String text, MaterialData icon, int amount) {
        this.item = new ItemStack(icon.getItemType(), 1, (short)icon.getData());
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(text);
        this.item.setItemMeta(meta);
        this.item.setAmount(amount);
    }

    public abstract void onClick(Player var1, boolean var2, boolean var3);

    protected void addToMenu(InventoryMenu menu) {
        this.menu = menu;
    }

    protected void removeFromMenu(InventoryMenu menu) {
        if (this.menu == menu) {
            this.menu = null;
        }
    }

    public InventoryMenu getMenu() {
        return this.menu;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getAmount() {
        return this.item.getAmount();
    }

    public MaterialData getIcon() {
        return this.item.getData();
    }

    public String getText() {
        return this.item.getItemMeta().getDisplayName();
    }

    public void setDescriptions(String ... lines) {
        ItemMeta meta = this.item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        for (String s : lines) {
            lore.addAll(Arrays.asList(Utilities.wrapWords(s, 24)));
        }
        meta.setLore(lore);
        this.item.setItemMeta(meta);
    }

    protected ItemStack getItemStack() {
        return this.item;
    }
}

