/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.events;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.events.core.ConsoleOutputScriptEvent;
import com.denizenscript.denizencore.events.core.DeltaTimeScriptEvent;
import com.denizenscript.denizencore.events.core.ReloadScriptsScriptEvent;
import com.denizenscript.denizencore.events.core.SystemTimeScriptEvent;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptEntrySet;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ScriptEvent
implements ContextSource,
Cloneable {
    public static ArrayList<ScriptContainer> worldContainers = new ArrayList();
    public static ArrayList<ScriptEvent> events = new ArrayList();
    public static HashMap<String, ScriptEvent> eventLookup = new HashMap();
    public StatData stats = new StatData();
    public ArrayList<ScriptPath> eventPaths = new ArrayList();
    public boolean cancelled = false;
    public static HashSet<String> defaultDeterminations = new HashSet<String>(Arrays.asList("cancelled", "cancelled:true", "cancelled:false"));
    Runnable resetRunnable = new Runnable(){

        @Override
        public void run() {
            ScriptEvent.this.reset();
        }
    };
    private String currentEvent;
    public static final HashMap<String, Pattern> knownPatterns = new HashMap();

    public ScriptEvent clone() {
        try {
            return (ScriptEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Debug.echoError("Clone not supported for script events?!");
            return this;
        }
    }

    public static void registerCoreEvents() {
        ScriptEvent.registerScriptEvent(new ConsoleOutputScriptEvent());
        ScriptEvent.registerScriptEvent(new DeltaTimeScriptEvent());
        ScriptEvent.registerScriptEvent(new ReloadScriptsScriptEvent());
        ScriptEvent.registerScriptEvent(new SystemTimeScriptEvent());
        ScriptEvent.registerScriptEvent(new TickScriptEvent());
    }

    public static void registerScriptEvent(ScriptEvent event) {
        event.reset();
        events.add(event);
        eventLookup.put(CoreUtilities.toLowerCase(event.getName()), event);
    }

    public static void reload() {
        Debug.log("Reloading script events...");
        for (ScriptContainer container : worldContainers) {
            if (!container.getContents().getString("enabled", "true").equalsIgnoreCase("true")) continue;
            YamlConfiguration config = container.getConfigurationSection("events");
            if (config == null) {
                Debug.echoError("Missing or invalid events block for " + container.getName());
                continue;
            }
            for (StringHolder evt : config.getKeys(false)) {
                if (evt == null || evt.str == null) {
                    Debug.echoError("Missing or invalid events block for " + container.getName());
                    continue;
                }
                if (!evt.str.contains("@")) continue;
                Debug.echoError("Script '" + container.getName() + "' has event '" + evt.str.replace("@", "<R>@<W>") + "' which contains object notation, which is deprecated for use in world events. Please remove it.");
            }
        }
        ArrayList<ScriptPath> paths = new ArrayList<ScriptPath>(worldContainers.size() * 3);
        for (ScriptContainer container : worldContainers) {
            YamlConfiguration config = container.getConfigurationSection("events");
            if (config == null) continue;
            for (StringHolder evt1 : config.getKeys(false)) {
                String evt = evt1.str.substring(3);
                paths.add(new ScriptPath(container, evt));
            }
        }
        for (ScriptEvent event : events) {
            try {
                event.destroy();
                event.eventPaths.clear();
                boolean matched = false;
                for (ScriptPath path : paths) {
                    if (!event.couldMatch(path)) continue;
                    event.eventPaths.add(path);
                    ++path.matches;
                    Debug.log("Event match, " + event.getName() + " matched for '" + path + "'!");
                    matched = true;
                }
                if (!matched) continue;
                event.sort();
                event.init();
            }
            catch (Throwable ex) {
                Debug.echoError("Failed to reload event '" + event.getName() + "':");
                Debug.echoError(ex);
            }
        }
        for (ScriptPath path : paths) {
            if (path.matches > 1) {
                Debug.log("Event " + path + " is matched to multiple ScriptEvents.");
                continue;
            }
            if (path.matches != 0) continue;
            Debug.log("Event " + path + " is not matched to any ScriptEvents.");
        }
    }

    public static boolean matchesScript(ScriptEvent sEvent, ScriptPath path) {
        if (path.switch_cancelled != null ? path.switch_cancelled != sEvent.cancelled : (path.switch_ignoreCancelled != null ? path.switch_ignoreCancelled == false && sEvent.cancelled : sEvent.cancelled)) {
            return false;
        }
        return sEvent.matches(path);
    }

    public void sort() {
        for (ScriptPath path : this.eventPaths) {
            String gotten = path.switches.get("priority");
            path.priority = gotten == null ? 0 : ArgumentHelper.getIntegerFrom(gotten);
        }
        Collections.sort(this.eventPaths, new Comparator<ScriptPath>(){

            @Override
            public int compare(ScriptPath scriptPath, ScriptPath t1) {
                int rel = scriptPath.priority - t1.priority;
                return rel < 0 ? -1 : (rel > 0 ? 1 : 0);
            }
        });
    }

    public void init() {
    }

    public void destroy() {
    }

    @Deprecated
    public static boolean checkSwitch(String event, String switcher, String value) {
        for (String possible : CoreUtilities.split(event, ' ')) {
            List<String> split = CoreUtilities.split(possible, ':', 2);
            if (!split.get(0).equalsIgnoreCase(switcher) || split.size() <= 1 || split.get(1).equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String getSwitch(String event, String switcher) {
        for (String possible : CoreUtilities.split(event, ' ')) {
            List<String> split = CoreUtilities.split(possible, ':', 2);
            if (!split.get(0).equalsIgnoreCase(switcher) || split.size() <= 1) continue;
            return split.get(1);
        }
        return null;
    }

    public static boolean isDefaultDetermination(ObjectTag determination) {
        if (!(determination instanceof ElementTag)) {
            return false;
        }
        String low = CoreUtilities.toLowerCase(determination.toString());
        return defaultDeterminations.contains(low);
    }

    public boolean applyDetermination(ScriptPath path, ObjectTag determination) {
        String low = CoreUtilities.toLowerCase(determination.toString());
        if (low.equals("cancelled")) {
            Debug.echoDebug((Debuggable)path.container, "Event cancelled!");
            this.cancelled = true;
            return true;
        }
        if (low.equals("cancelled:true")) {
            Debug.echoDebug((Debuggable)path.container, "Event cancelled!");
            this.cancelled = true;
            return true;
        }
        if (low.equals("cancelled:false")) {
            Debug.echoDebug((Debuggable)path.container, "Event uncancelled!");
            this.cancelled = false;
            return true;
        }
        Debug.echoError("Unknown determination '" + determination + "'");
        return false;
    }

    public HashMap<String, ObjectTag> getContext() {
        return new HashMap<String, ObjectTag>();
    }

    public ScriptEntryData getScriptEntryData() {
        return DenizenCore.getImplementation().getEmptyScriptEntryData();
    }

    public boolean couldMatch(ScriptPath path) {
        return this.couldMatch(path.container, path.event);
    }

    public boolean couldMatch(ScriptContainer script, String event) {
        return false;
    }

    public boolean matches(ScriptPath path) {
        return this.matches(path.container, path.event);
    }

    public boolean matches(ScriptContainer script, String event) {
        throw new UnsupportedOperationException("Matches not implemented for event '" + this.getName() + "'! Report this error to the Denizen developers!");
    }

    public abstract String getName();

    public void reset() {
        this.cancelled = false;
    }

    public void fire() {
        ++this.stats.fires;
        for (ScriptPath path : this.eventPaths) {
            try {
                if (!ScriptEvent.matchesScript(this, path)) continue;
                this.run(path);
            }
            catch (Exception e) {
                Debug.echoError("Handling script " + path.container.getName() + " path:" + path.event + ":::");
                Debug.echoError(e);
            }
        }
        if (this.cancelled) {
            DenizenCore.schedule(new OneTimeSchedulable(this.resetRunnable, 0.01f));
        }
    }

    public void run(ScriptPath path) {
        ++this.stats.scriptFires;
        HashMap<String, ObjectTag> context = this.getContext();
        if (path.container.shouldDebug()) {
            Debug.echoDebug((Debuggable)path.container, "<Y>Running script event '<A>" + this.getName() + "<Y>', event='<A>" + path.event + "<Y>' for script '<A>" + path.container.getName() + "<Y>'");
            for (Map.Entry<String, ObjectTag> obj : context.entrySet()) {
                Debug.echoDebug((Debuggable)path.container, "<Y>Context '<A>" + obj.getKey() + "<Y>' = '<A>" + obj.getValue().identify() + "<Y>'");
            }
        }
        if (path.set == null) {
            path.set = path.container.getSetFor("events.on " + path.event);
        }
        List<ScriptEntry> entries = ScriptContainer.cleanDup(this.getScriptEntryData(), path.set);
        ScriptQueue queue = new InstantQueue(path.container.getName()).addEntries(entries);
        HashMap<String, ObjectTag> oldStyleContext = this.getContext();
        this.currentEvent = path.event;
        if (oldStyleContext.size() > 0) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = oldStyleContext;
            oecs.contexts.put("cancelled", new ElementTag(this.cancelled));
            oecs.contexts.put("event_header", new ElementTag(this.currentEvent));
            queue.setContextSource(oecs);
        } else {
            queue.setContextSource(this.clone());
        }
        queue.start();
        this.stats.nanoTimes += System.nanoTime() - queue.startTime;
        ListTag outList = queue.determinations;
        if (outList != null && !outList.isEmpty()) {
            ArrayList<ObjectTag> determinations = outList.objectForms;
            for (ObjectTag determination : determinations) {
                this.applyDetermination(path, determination);
            }
        }
    }

    @Override
    public boolean getShouldCache() {
        return false;
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("cancelled")) {
            return new ElementTag(this.cancelled);
        }
        if (name.equals("event_header")) {
            return new ElementTag(this.currentEvent);
        }
        if (name.equals("event_name")) {
            return new ElementTag(this.getName());
        }
        return null;
    }

    public static String quotify(String input) {
        StringBuilder output = new StringBuilder(input.length());
        int last = 0;
        int index = input.indexOf(42);
        while (index >= 0) {
            output.append(Pattern.quote(input.substring(last, index))).append("(.*)");
            last = index + 1;
            index = input.indexOf(42, last);
        }
        output.append(Pattern.quote(input.substring(last)));
        return output.toString();
    }

    public static Pattern regexHandle(String input) {
        String output;
        Pattern result = knownPatterns.get(input);
        if (result != null) {
            return result;
        }
        if (input.startsWith("regex:")) {
            output = input.substring("regex:".length());
        } else if (input.contains("|")) {
            CharSequence[] split = input.split("\\|");
            for (int i = 0; i < split.length; ++i) {
                split[i] = ScriptEvent.quotify((String)split[i]);
            }
            output = String.join((CharSequence)"|", split);
        } else if (input.contains("*")) {
            output = ScriptEvent.quotify(input);
        } else {
            return null;
        }
        if (Debug.verbose) {
            Debug.log("Event regex compile: " + output);
        }
        result = Pattern.compile(output);
        knownPatterns.put(input, result);
        return result;
    }

    public static boolean equalityCheck(String input, String compared, Pattern regexed) {
        return (input = CoreUtilities.toLowerCase(input)).equals(compared) || regexed != null && regexed.matcher(input).matches();
    }

    public static class ScriptPath {
        public ScriptContainer container;
        public String event;
        public String eventLower;
        public int priority = 0;
        public ScriptEntrySet set;
        public Boolean switch_cancelled;
        public Boolean switch_ignoreCancelled;
        public HashMap<String, String> switches = new HashMap();
        public String[] eventArgs;
        public String[] eventArgsLower;
        public String[] rawEventArgs;
        public int matches = 0;

        public String rawEventArgAt(int index) {
            return index < this.rawEventArgs.length ? this.rawEventArgs[index] : "";
        }

        public String eventArgAt(int index) {
            return index < this.eventArgs.length ? this.eventArgs[index] : "";
        }

        public String eventArgLowerAt(int index) {
            return index < this.eventArgsLower.length ? this.eventArgsLower[index] : "";
        }

        public boolean checkSwitch(String key, String value) {
            String pathValue = this.switches.get(key);
            if (pathValue == null) {
                return true;
            }
            return CoreUtilities.toLowerCase(pathValue).equals(value);
        }

        public ScriptPath(ScriptContainer container, String event) {
            this.event = event;
            this.rawEventArgs = CoreUtilities.split(event, ' ').toArray(new String[0]);
            this.container = container;
            ArrayList<String> eventLabel = new ArrayList<String>();
            for (String possible : CoreUtilities.split(event, ' ').toArray(new String[0])) {
                List<String> split = CoreUtilities.split(possible, ':', 2);
                if (split.size() > 1 && !split.get(0).equalsIgnoreCase("regex")) {
                    this.switches.put(CoreUtilities.toLowerCase(split.get(0)), split.get(1));
                    continue;
                }
                eventLabel.add(possible);
            }
            this.eventLower = CoreUtilities.toLowerCase(String.join((CharSequence)" ", eventLabel));
            this.eventArgs = eventLabel.toArray(new String[0]);
            this.eventArgsLower = CoreUtilities.split(this.eventLower, ' ').toArray(new String[0]);
            this.switch_cancelled = this.switches.containsKey("cancelled") ? Boolean.valueOf(this.switches.get("cancelled").equalsIgnoreCase("true")) : null;
            this.switch_ignoreCancelled = this.switches.containsKey("ignorecancelled") ? Boolean.valueOf(this.switches.get("ignorecancelled").equalsIgnoreCase("true")) : null;
        }

        public String toString() {
            return this.container.getName() + ".events.on " + this.event;
        }
    }

    public static class StatData {
        public long fires = 0L;
        public long scriptFires = 0L;
        public long nanoTimes = 0L;
    }
}

