/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class YamlCommand
extends AbstractCommand
implements Holdable {
    Map<String, YamlConfiguration> yamls = new HashMap<String, YamlConfiguration>();

    @Override
    public void onEnable() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                YamlCommand.this.yaml(event);
            }
        }, "yaml");
    }

    private YamlConfiguration getYaml(String id) {
        if (id == null) {
            Debug.echoError("Trying to get YAML file with NULL ID!");
            return null;
        }
        return this.yamls.get(id.toUpperCase());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean isSet = false;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            String[] flagArgs;
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("load")) {
                scriptEntry.addObject("action", new ElementTag("LOAD"));
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("loadtext")) {
                scriptEntry.addObject("action", new ElementTag("LOADTEXT"));
                scriptEntry.addObject("raw_text", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("savefile", "filesave")) {
                scriptEntry.addObject("action", new ElementTag("SAVE"));
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("create")) {
                scriptEntry.addObject("action", new ElementTag("CREATE"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("set")) {
                scriptEntry.addObject("action", new ElementTag("SET"));
                isSet = true;
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("copykey")) {
                scriptEntry.addObject("action", new ElementTag("COPYKEY"));
                scriptEntry.addObject("key", arg.asElement());
                isSet = true;
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("unload")) {
                scriptEntry.addObject("action", new ElementTag("UNLOAD"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("write")) {
                Debug.echoError(scriptEntry.getResidingQueue(), "YAML write is deprecated, use YAML set!");
                scriptEntry.addObject("action", new ElementTag("WRITE"));
                scriptEntry.addObject("key", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesPrefix("value")) {
                if (arg.matchesArgumentType(ListTag.class)) {
                    scriptEntry.addObject("value", arg.asType(ListTag.class));
                    continue;
                }
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("to_id") && arg.matchesPrefix("to_id")) {
                scriptEntry.addObject("to_id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("split") && arg.matches("split_list")) {
                scriptEntry.addObject("split", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("fix_formatting") && arg.matches("fix_formatting")) {
                scriptEntry.addObject("fix_formatting", new ElementTag("true"));
                continue;
            }
            if (isSet && !scriptEntry.hasObject("value") && arg.raw_value.split(":", 3).length == 2) {
                flagArgs = arg.raw_value.split(":", 2);
                scriptEntry.addObject("key", new ElementTag(flagArgs[0]));
                if (flagArgs[1].equals("++") || flagArgs[1].equals("+")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.INCREASE);
                    scriptEntry.addObject("value", new ElementTag(1));
                    continue;
                }
                if (flagArgs[1].equals("--") || flagArgs[1].equals("-")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.DECREASE);
                    scriptEntry.addObject("value", new ElementTag(1));
                    continue;
                }
                if (flagArgs[1].equals("!")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.DELETE);
                    scriptEntry.addObject("value", new ElementTag(false));
                    continue;
                }
                if (flagArgs[1].equals("<-")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.REMOVE);
                    scriptEntry.addObject("value", new ElementTag(false));
                    continue;
                }
                scriptEntry.addObject("yaml_action", (Object)YAML_Action.SET_VALUE);
                scriptEntry.addObject("value", new ElementTag(flagArgs[1]));
                continue;
            }
            if (isSet && !scriptEntry.hasObject("value") && arg.raw_value.split(":", 3).length == 3) {
                flagArgs = arg.raw_value.split(":", 3);
                scriptEntry.addObject("key", new ElementTag(flagArgs[0]));
                if (flagArgs[1].equals("->")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.INSERT);
                } else if (flagArgs[1].equals("<-")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.REMOVE);
                } else if (flagArgs[1].equals("||") || flagArgs[1].equals("|")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.SPLIT);
                } else if (flagArgs[1].equals("!|")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.SPLIT_NEW);
                } else if (flagArgs[1].equals("++") || flagArgs[1].equals("+")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.INCREASE);
                } else if (flagArgs[1].equals("--") || flagArgs[1].equals("-")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.DECREASE);
                } else if (flagArgs[1].equals("**") || flagArgs[1].equals("*")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.MULTIPLY);
                } else if (flagArgs[1].equals("//") || flagArgs[1].equals("/")) {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.DIVIDE);
                } else {
                    scriptEntry.addObject("yaml_action", (Object)YAML_Action.SET_VALUE);
                    scriptEntry.addObject("value", new ElementTag(arg.raw_value.split(":", 2)[1]));
                    continue;
                }
                scriptEntry.addObject("value", new ElementTag(flagArgs[2]));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an id!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        if (!scriptEntry.hasObject("key") && scriptEntry.getElement("action").asString().equalsIgnoreCase("write")) {
            throw new InvalidArgumentsException("Must specify a key!");
        }
        scriptEntry.defaultObject("value", new ElementTag(""));
        scriptEntry.defaultObject("fix_formatting", new ElementTag("false"));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        ElementTag filename = scriptEntry.getElement("filename");
        ElementTag rawText = scriptEntry.getElement("raw_text");
        ElementTag key = scriptEntry.getElement("key");
        Object value = scriptEntry.getObjectTag("value");
        ElementTag split = scriptEntry.getElement("split");
        YAML_Action yaml_action = (YAML_Action)((Object)scriptEntry.getObject("yaml_action"));
        ElementTag actionElement = scriptEntry.getElement("action");
        ElementTag idElement = scriptEntry.getElement("id");
        final ElementTag fixFormatting = scriptEntry.getElement("fix_formatting");
        ElementTag toId = scriptEntry.getElement("to_id");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), idElement.debug() + actionElement.debug() + (filename != null ? filename.debug() : "") + (yaml_action != null ? ArgumentHelper.debugObj("yaml_action", yaml_action.name()) : "") + (key != null ? key.debug() : "") + (value != null ? value.debug() : "") + (split != null ? split.debug() : "") + (rawText != null ? rawText.debug() : "") + (toId != null ? toId.debug() : "") + fixFormatting.debug());
        }
        Action action = Action.valueOf(actionElement.asString().toUpperCase());
        final String id = idElement.asString().toUpperCase();
        if (action != Action.LOAD && action != Action.SAVE && scriptEntry.shouldWaitFor()) {
            scriptEntry.setFinished(true);
        }
        switch (action) {
            case LOAD: {
                final File file = new File(DenizenCore.getImplementation().getDataFolder(), filename.asString());
                if (!DenizenCore.getImplementation().canReadFile(file)) {
                    Debug.echoError("Server config denies reading files in that location.");
                    scriptEntry.setFinished(true);
                    return;
                }
                if (!file.exists()) {
                    Debug.echoError("File cannot be found!");
                    scriptEntry.setFinished(true);
                    return;
                }
                final YamlConfiguration[] runnableConfigs = new YamlConfiguration[1];
                final Runnable onLoadCompleted = new Runnable(){

                    @Override
                    public void run() {
                        if (YamlCommand.this.yamls.containsKey(id)) {
                            YamlCommand.this.yamls.remove(id);
                        }
                        YamlCommand.this.yamls.put(id, runnableConfigs[0]);
                        scriptEntry.setFinished(true);
                    }
                };
                Runnable loadRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileInputStream fis = new FileInputStream(file);
                            String str = ScriptHelper.convertStreamToString(fis);
                            if (fixFormatting.asBoolean()) {
                                str = ScriptHelper.clearComments("", str, false);
                            }
                            runnableConfigs[0] = YamlConfiguration.load(str);
                            fis.close();
                            if (runnableConfigs[0] == null) {
                                runnableConfigs[0] = new YamlConfiguration();
                            }
                            if (scriptEntry.shouldWaitFor()) {
                                DenizenCore.schedule(new OneTimeSchedulable(onLoadCompleted, 0.0f));
                            } else {
                                onLoadCompleted.run();
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError("Failed to load yaml file: " + e);
                        }
                    }
                };
                if (scriptEntry.shouldWaitFor()) {
                    DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(loadRunnable, 0.0f)));
                    break;
                }
                loadRunnable.run();
                break;
            }
            case LOADTEXT: {
                String str = rawText.asString();
                if (fixFormatting.asBoolean()) {
                    str = ScriptHelper.clearComments("", str, false);
                }
                YamlConfiguration config = YamlConfiguration.load(str);
                if (this.yamls.containsKey(id)) {
                    this.yamls.remove(id);
                }
                this.yamls.put(id, config);
                scriptEntry.setFinished(true);
                break;
            }
            case UNLOAD: {
                if (this.yamls.containsKey(id)) {
                    this.yamls.remove(id);
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                break;
            }
            case SAVE: {
                if (this.yamls.containsKey(id)) {
                    try {
                        File fileObj;
                        if (!DenizenCore.getImplementation().allowStrangeYAMLSaves()) {
                            fileObj = new File(DenizenCore.getImplementation().getDataFolder().getAbsolutePath() + "/" + filename.asString());
                            String directory = URLDecoder.decode(System.getProperty("user.dir"));
                            if (!fileObj.getCanonicalPath().startsWith(directory)) {
                                Debug.echoError("Outside-the-main-folder YAML saves disabled by administrator.");
                                scriptEntry.setFinished(true);
                                return;
                            }
                        }
                        fileObj = new File(DenizenCore.getImplementation().getDataFolder().getAbsolutePath() + "/" + filename.asString());
                        if (!DenizenCore.getImplementation().canWriteToFile(fileObj)) {
                            Debug.echoError(scriptEntry.getResidingQueue(), "Cannot edit that file!");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        fileObj.getParentFile().mkdirs();
                        final String outp = this.yamls.get(id).saveToString();
                        Runnable saveRunnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FileWriter fw = new FileWriter(fileObj.getAbsoluteFile());
                                    BufferedWriter writer = new BufferedWriter(fw);
                                    writer.write(outp);
                                    writer.close();
                                    fw.close();
                                }
                                catch (IOException e) {
                                    Debug.echoError(e);
                                }
                                scriptEntry.setFinished(true);
                            }
                        };
                        if (scriptEntry.shouldWaitFor()) {
                            DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(saveRunnable, 0.0f)));
                            break;
                        }
                        saveRunnable.run();
                    }
                    catch (IOException e) {
                        Debug.echoError(e);
                    }
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                scriptEntry.setFinished(true);
                break;
            }
            case WRITE: {
                if (this.yamls.containsKey(id)) {
                    if (value instanceof ElementTag) {
                        this.yamls.get(id).set(key.asString(), ((ElementTag)value).asString());
                        break;
                    }
                    if (split != null && split.asBoolean()) {
                        this.yamls.get(id).set(key.asString(), value);
                        break;
                    }
                    this.yamls.get(id).set(key.asString(), value.identify());
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                break;
            }
            case COPYKEY: {
                YamlConfiguration yaml;
                if (!this.yamls.containsKey(id)) break;
                YamlConfiguration destYaml = yaml = this.yamls.get(id);
                if (toId != null) {
                    if (this.yamls.containsKey(toId.toString().toUpperCase())) {
                        destYaml = this.yamls.get(toId.toString().toUpperCase());
                    } else {
                        Debug.echoError("Unknown YAML TO-ID '" + id + "'");
                        break;
                    }
                }
                YamlConfiguration sourceSection = yaml.getConfigurationSection(key.asString());
                YamlConfiguration newSection = this.copySection(sourceSection);
                destYaml.set(value.toString(), newSection);
                break;
            }
            case SET: {
                if (this.yamls.containsKey(id)) {
                    if (yaml_action == null || key == null || value == null) {
                        Debug.echoError("Must specify a YAML action and value!");
                        return;
                    }
                    YamlConfiguration yaml = this.yamls.get(id);
                    int index = -1;
                    if (key.asString().contains("[")) {
                        try {
                            if (Debug.verbose) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Try index: " + key.asString().split("\\[")[1].replace("]", ""));
                            }
                            index = Integer.valueOf(key.asString().split("\\[")[1].replace("]", "")) - 1;
                        }
                        catch (Exception e) {
                            if (Debug.verbose) {
                                Debug.echoError(scriptEntry.getResidingQueue(), e);
                            }
                            index = -1;
                        }
                        key = ElementTag.valueOf(key.asString().split("\\[")[0]);
                    }
                    String keyStr = key.asString();
                    String valueStr = value.identify();
                    switch (yaml_action) {
                        case INCREASE: {
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(ArgumentHelper.getDoubleFrom(this.Get(yaml, index, keyStr, "0")) + ArgumentHelper.getDoubleFrom(valueStr)));
                            break;
                        }
                        case DECREASE: {
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(ArgumentHelper.getDoubleFrom(this.Get(yaml, index, keyStr, "0")) - ArgumentHelper.getDoubleFrom(valueStr)));
                            break;
                        }
                        case MULTIPLY: {
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(ArgumentHelper.getDoubleFrom(this.Get(yaml, index, keyStr, "1")) * ArgumentHelper.getDoubleFrom(valueStr)));
                            break;
                        }
                        case DIVIDE: {
                            this.Set(yaml, index, keyStr, CoreUtilities.doubleToString(ArgumentHelper.getDoubleFrom(this.Get(yaml, index, keyStr, "1")) / ArgumentHelper.getDoubleFrom(valueStr)));
                            break;
                        }
                        case DELETE: {
                            yaml.set(keyStr, null);
                            break;
                        }
                        case SET_VALUE: {
                            this.Set(yaml, index, keyStr, valueStr);
                            break;
                        }
                        case INSERT: {
                            List<String> list = yaml.getStringList(keyStr);
                            if (list == null) {
                                list = new ArrayList<String>();
                            }
                            list.add(valueStr);
                            yaml.set(keyStr, list);
                            break;
                        }
                        case REMOVE: {
                            List<String> list = yaml.getStringList(keyStr);
                            if (list == null) {
                                if (!Debug.verbose) break;
                                Debug.echoDebug((Debuggable)scriptEntry, "List null!");
                                break;
                            }
                            if (index > -1 && index < list.size()) {
                                if (Debug.verbose) {
                                    Debug.echoDebug((Debuggable)scriptEntry, "Remove ind: " + index);
                                }
                                list.remove(index);
                                yaml.set(keyStr, list);
                                break;
                            }
                            if (Debug.verbose) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Remvoe value: " + valueStr);
                            }
                            for (int i = 0; i < list.size(); ++i) {
                                if (!list.get(i).equalsIgnoreCase(valueStr)) continue;
                                list.remove(i);
                                break;
                            }
                            yaml.set(keyStr, list);
                            break;
                        }
                        case SPLIT_NEW: {
                            yaml.set(keyStr, new ArrayList<String>(ListTag.valueOf(valueStr)));
                            break;
                        }
                        case SPLIT: {
                            List<String> list = yaml.getStringList(keyStr);
                            if (list == null) {
                                list = new ArrayList<String>();
                            }
                            list.addAll(ListTag.valueOf(valueStr));
                            yaml.set(keyStr, list);
                            break;
                        }
                    }
                    break;
                }
                Debug.echoError("Unknown YAML ID '" + id + "'");
                break;
            }
            case CREATE: {
                if (this.yamls.containsKey(id)) {
                    this.yamls.remove(id);
                }
                YamlConfiguration yamlConfiguration = new YamlConfiguration();
                this.yamls.put(id.toUpperCase(), yamlConfiguration);
            }
        }
    }

    public YamlConfiguration copySection(YamlConfiguration section) {
        YamlConfiguration newSection = new YamlConfiguration();
        for (StringHolder key : section.getKeys(false)) {
            Object obj = section.get(key.str);
            if (obj instanceof YamlConfiguration) {
                obj = this.copySection((YamlConfiguration)obj);
            }
            newSection.set(key.str, obj);
        }
        return newSection;
    }

    public String Get(YamlConfiguration yaml, int index, String key, String def) {
        if (index == -1) {
            return yaml.getString(key, def);
        }
        List<String> list = yaml.getStringList(key);
        if (index < 0) {
            index = 0;
        }
        if (index > list.size()) {
            index = list.size() - 1;
        }
        if (list.size() == 0) {
            return "";
        }
        return list.get(index);
    }

    public void Set(YamlConfiguration yaml, int index, String key, String value) {
        if (index == -1) {
            yaml.set(key, value);
        } else {
            List<String> list = yaml.getStringList(key);
            if (list == null) {
                list = new ArrayList<String>();
            }
            if (index < 0) {
                index = 0;
            }
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.set(index, value);
            }
            yaml.set(key, list);
        }
    }

    public void yaml(ReplaceableTagEvent event) {
        if (!event.matches("yaml")) {
            return;
        }
        Attribute attribute = event.getAttributes();
        if (attribute.getAttribute(2).equalsIgnoreCase("list")) {
            ListTag list = new ListTag();
            list.addAll((Collection<? extends String>)this.yamls.keySet());
            event.setReplaced(list.getAttribute(attribute.fulfill(2)));
            return;
        }
        if (!(event.hasNameContext() && (event.hasTypeContext() || attribute.getAttribute(2).equalsIgnoreCase("to_json")) || attribute.hasAlternative())) {
            Debug.echoError("YAML tag '" + event.raw_tag + "' is missing required context. Tag replacement aborted.");
            return;
        }
        String id = event.getNameContext().toUpperCase();
        String path = event.getTypeContext();
        if (!this.yamls.containsKey(id)) {
            if (!attribute.hasAlternative()) {
                Debug.echoError("YAML tag '" + event.raw_tag + "' has specified an invalid ID, or the specified id has already been closed. Tag replacement aborted. ID given: '" + id + "'.");
            }
            return;
        }
        attribute.fulfill(1);
        if (attribute.startsWith("contains")) {
            event.setReplaced(new ElementTag(this.getYaml(id).contains(path)).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("is_list")) {
            event.setReplaced(new ElementTag(this.getYaml(id).isList(path)).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("read")) {
            attribute.fulfill(1);
            if (this.getYaml(id).isList(path)) {
                List<String> value = this.getYaml(id).getStringList(path);
                if (value == null) {
                    return;
                }
                event.setReplaced(new ListTag(value).getAttribute(attribute));
                return;
            }
            String value = this.getYaml(id).getString(path);
            if (value == null) {
                return;
            }
            event.setReplaced(new ElementTag(value).getAttribute(attribute));
            return;
        }
        if (attribute.startsWith("list_deep_keys")) {
            Set<StringHolder> keys;
            if (path != null && path.length() > 0) {
                YamlConfiguration section = this.getYaml(id).getConfigurationSection(path);
                if (section == null) {
                    return;
                }
                keys = section.getKeys(true);
            } else {
                keys = this.getYaml(id).getKeys(true);
            }
            if (keys == null) {
                return;
            }
            event.setReplaced(new ListTag(keys).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list_keys")) {
            Set<StringHolder> keys;
            if (path != null && path.length() > 0) {
                YamlConfiguration section = this.getYaml(id).getConfigurationSection(path);
                if (section == null) {
                    return;
                }
                keys = section.getKeys(false);
            } else {
                keys = this.getYaml(id).getKeys(false);
            }
            if (keys == null) {
                return;
            }
            event.setReplaced(new ListTag(keys).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("to_json")) {
            JSONObject jsobj = new JSONObject(this.getYaml(id).getMap());
            event.setReplaced(new ElementTag(jsobj.toString()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("to_text")) {
            event.setReplaced(new ElementTag(this.getYaml(id).saveToString()).getAttribute(attribute.fulfill(1)));
            return;
        }
    }

    public static enum YAML_Action {
        SET_VALUE,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE,
        SPLIT,
        DELETE,
        SPLIT_NEW;

    }

    public static enum Action {
        LOAD,
        LOADTEXT,
        UNLOAD,
        CREATE,
        WRITE,
        SAVE,
        SET,
        COPYKEY;

    }
}

