/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.helpers;

import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.impl.ImprovedOfflinePlayer_v1_14_R1;
import com.denizenscript.denizen.nms.impl.packets.handlers.AbstractListenerPlayIn_v1_14_R1;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.v1_14_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_14_R1.DataWatcherRegistry;
import net.minecraft.server.v1_14_R1.DedicatedServer;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.JsonListEntry;
import net.minecraft.server.v1_14_R1.OpList;
import net.minecraft.server.v1_14_R1.OpListEntry;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_14_R1.PlayerChunkMap;
import net.minecraft.server.v1_14_R1.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_14_R1.CraftServer;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class PlayerHelper_v1_14_R1
extends PlayerHelper {
    public static final Field ATTACK_COOLDOWN_TICKS = (Field)ReflectionHelper.getFields(EntityLiving.class).get("aD");
    public static final Map<String, Field> PLAYER_CONNECTION_FIELDS = ReflectionHelper.getFields(PlayerConnection.class);
    public static final Field FLY_TICKS = PLAYER_CONNECTION_FIELDS.get("C");
    public static final Field VEHICLE_FLY_TICKS = PLAYER_CONNECTION_FIELDS.get("E");
    public static final Field PLAYER_MAP = (Field)ReflectionHelper.getFields(PlayerChunkMap.class).get("y");

    public int getFlyKickCooldown(Player player) {
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
        if (conn instanceof AbstractListenerPlayIn_v1_14_R1) {
            conn = ((AbstractListenerPlayIn_v1_14_R1)conn).oldListener;
        }
        try {
            return Math.max(80 - Math.max(FLY_TICKS.getInt(conn), VEHICLE_FLY_TICKS.getInt(conn)), 0);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return 80;
        }
    }

    public void setFlyKickCooldown(Player player, int ticks) {
        ticks = 80 - ticks;
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
        if (conn instanceof AbstractListenerPlayIn_v1_14_R1) {
            conn = ((AbstractListenerPlayIn_v1_14_R1)conn).oldListener;
        }
        try {
            FLY_TICKS.setInt(conn, ticks);
            VEHICLE_FLY_TICKS.setInt(conn, ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public float getAbsorption(Player player) {
        return ((Float)((CraftPlayer)player).getHandle().getDataWatcher().get(DataWatcherRegistry.c.a(11))).floatValue();
    }

    public void setAbsorption(Player player, float value) {
        ((CraftPlayer)player).getHandle().getDataWatcher().set(DataWatcherRegistry.c.a(11), (Object)Float.valueOf(value));
    }

    public int ticksPassedDuringCooldown(Player player) {
        try {
            return ATTACK_COOLDOWN_TICKS.getInt(((CraftPlayer)player).getHandle());
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return -1;
        }
    }

    public float getMaxAttackCooldownTicks(Player player) {
        return ((CraftPlayer)player).getHandle().dY() + 3.0f;
    }

    public float getAttackCooldownPercent(Player player) {
        return ((CraftPlayer)player).getHandle().s(0.5f);
    }

    public void setAttackCooldown(Player player, int ticks) {
        try {
            ATTACK_COOLDOWN_TICKS.setInt(((CraftPlayer)player).getHandle(), ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public boolean hasChunkLoaded(Player player, Chunk chunk) {
        return ((CraftWorld)chunk.getWorld()).getHandle().getChunkProvider().playerChunkMap.a(new ChunkCoordIntPair(chunk.getX(), chunk.getZ()), false).anyMatch(entityPlayer -> entityPlayer.getUniqueID().equals(player.getUniqueId()));
    }

    public int getPing(Player player) {
        return ((CraftPlayer)player).getHandle().ping;
    }

    public void setTemporaryOp(Player player, boolean op) {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        OpList opList = server.getPlayerList().getOPs();
        if (op) {
            int permLevel = server.j();
            opList.add((JsonListEntry)new OpListEntry(profile, permLevel, opList.b(profile)));
        } else {
            opList.remove((Object)profile);
        }
        player.recalculatePermissions();
    }

    public void showEndCredits(Player player) {
        ((CraftPlayer)player).getHandle().viewingCredits = true;
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutGameStateChange(4, 0.0f));
    }

    public ImprovedOfflinePlayer getOfflineData(UUID uuid) {
        return new ImprovedOfflinePlayer_v1_14_R1(uuid);
    }

    public ImprovedOfflinePlayer getOfflineData(OfflinePlayer offlinePlayer) {
        return new ImprovedOfflinePlayer_v1_14_R1(offlinePlayer.getUniqueId());
    }
}

