/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCanBuildEvent;

public class BlockBuiltScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockBuiltScriptEvent instance;
    public LocationTag location;
    public MaterialTag old_material;
    public MaterialTag new_material;
    public BlockCanBuildEvent event;

    public BlockBuiltScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(1).equals("being") && path.eventArgLowerAt(2).equals("built");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String mat1 = path.eventArgLowerAt(0);
        if (!this.tryMaterial(this.new_material, mat1)) {
            return false;
        }
        String mat2 = path.eventArgLowerAt(4);
        return mat2.length() <= 0 || this.tryMaterial(this.old_material, mat2);
    }

    @Override
    public String getName() {
        return "BlockBuilt";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination;
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determination = determinationObj.toString())).equals("buildable")) {
            this.cancelled = false;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("new_material")) {
            return this.new_material;
        }
        if (name.equals("old_material")) {
            return this.old_material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockBuilt(BlockCanBuildEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.old_material = new MaterialTag(event.getBlock());
        this.new_material = new MaterialTag(event.getMaterial());
        this.cancelled = !event.isBuildable();
        this.event = event;
        this.fire((Event)event);
        event.setBuildable(!this.cancelled);
    }
}

