/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class CauldronLevelChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static CauldronLevelChangeScriptEvent instance;
    public LocationTag location;
    public CauldronLevelChangeEvent event;

    public CauldronLevelChangeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("cauldron level ");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!this.runGenericSwitchCheck(path, "cause", this.event.getReason().name())) {
            return false;
        }
        String changeType = path.eventArgLowerAt(2);
        return !(changeType.equals("raises") ? this.event.getNewLevel() <= this.event.getOldLevel() : (changeType.equals("lowers") ? this.event.getNewLevel() >= this.event.getOldLevel() : !changeType.equals("changes")));
    }

    @Override
    public String getName() {
        return "CauldronLevelChange";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (!CauldronLevelChangeScriptEvent.isDefaultDetermination(determinationObj) && determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.event.setNewLevel(((ElementTag)determinationObj).asInt());
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("cause")) {
            return new ElementTag(this.event.getReason().name());
        }
        if (name.equals("old_level")) {
            return new ElementTag(this.event.getOldLevel());
        }
        if (name.equals("new_level")) {
            return new ElementTag(this.event.getNewLevel());
        }
        if (name.equals("entity") && this.event.getEntity() != null) {
            return new EntityTag(this.event.getEntity());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCauldronLevelChange(CauldronLevelChangeEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

