/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;

public class EntityEntersPortalScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityEntersPortalScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    public EntityPortalEnterEvent event;

    public EntityEntersPortalScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).contains("enters portal");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityEntersPortal";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? EntityTag.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? EntityTag.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityEntersPortal(EntityPortalEnterEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

