/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class PlayerPicksUpScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPicksUpScriptEvent instance;
    public ItemTag item;
    public boolean itemChanged;
    public EntityTag entity;
    public LocationTag location;
    public PlayerPickupItemEvent event;
    private static final Set<UUID> editedItems;

    public PlayerPicksUpScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (CoreUtilities.xthArgEquals(3, lower, "from")) {
            return false;
        }
        return lower.startsWith("player picks up") || lower.startsWith("player takes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String iTest;
        String string = iTest = path.eventArgLowerAt(1).equals("picks") ? path.eventArgLowerAt(3) : path.eventArgLowerAt(2);
        if (!this.tryItem(this.item, iTest)) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "PlayerPicksUp";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("item:")) {
            this.item = ItemTag.valueOf(determination.substring("item:".length()), path.container);
            this.itemChanged = true;
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag(this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerPicksUp(PlayerPickupItemEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Item itemEntity = event.getItem();
        UUID itemUUID = itemEntity.getUniqueId();
        if (editedItems.contains(itemUUID)) {
            editedItems.remove(itemUUID);
            return;
        }
        this.location = new LocationTag(itemEntity.getLocation());
        this.item = new ItemTag(itemEntity.getItemStack());
        this.entity = new EntityTag((Entity)itemEntity);
        this.itemChanged = false;
        this.event = event;
        this.fire((Event)event);
        if (this.itemChanged) {
            itemEntity.setItemStack(this.item.getItemStack());
            editedItems.add(itemUUID);
            event.setCancelled(true);
        }
    }

    static {
        editedItems = new HashSet<UUID>();
    }
}

