/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;

public class PlayerPreparesAnvilCraftScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPreparesAnvilCraftScriptEvent instance;
    public boolean resultChanged;
    public ItemTag result;
    public AnvilInventory inventory;
    public PlayerTag player;
    public ElementTag repairCost;
    public ElementTag newName;

    public PlayerPreparesAnvilCraftScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player prepares anvil craft");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String eItem = path.eventArgLowerAt(4);
        return this.tryItem(this.result, eItem);
    }

    @Override
    public String getName() {
        return "PlayerPreparesAnvilCraft";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.repairCost = (ElementTag)determinationObj;
            return true;
        }
        String determination = determinationObj.toString();
        if (ItemTag.matches(determination)) {
            this.result = ItemTag.valueOf(determination, path.container);
            this.resultChanged = true;
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.result;
        }
        if (name.equals("repair_cost")) {
            return this.repairCost;
        }
        if (name.equals("new_name")) {
            return this.newName;
        }
        if (name.equals("inventory")) {
            return InventoryTag.mirrorBukkitInventory((Inventory)this.inventory);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCraftItem(PrepareAnvilEvent event) {
        if (event.getInventory().getViewers().size() == 0) {
            return;
        }
        HumanEntity humanEntity = (HumanEntity)event.getInventory().getViewers().get(0);
        if (EntityTag.isNPC((Entity)humanEntity)) {
            return;
        }
        this.inventory = event.getInventory();
        this.repairCost = new ElementTag(this.inventory.getRepairCost());
        this.newName = new ElementTag(this.inventory.getRenameText());
        this.result = new ItemTag(event.getResult());
        this.player = EntityTag.getPlayerFrom((Entity)humanEntity);
        this.resultChanged = false;
        this.cancelled = false;
        this.fire((Event)event);
        this.inventory.setRepairCost(this.repairCost.asInt());
        if (this.resultChanged) {
            event.setResult(this.result.getItemStack());
        }
    }
}

