/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;

public class PlayerRightClicksEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerRightClicksEntityScriptEvent instance;
    PlayerInteractEntityEvent event;
    EntityTag entity;
    ItemTag item;
    LocationTag location;

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player right clicks");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        boolean isAt = path.eventArgLowerAt(3).equals("at");
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(isAt ? 4 : 3))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        if (!this.runWithCheck(path, this.item)) {
            return false;
        }
        return !path.eventArgLowerAt(isAt ? 5 : 4).equals("with") || this.tryItem(this.item, path.eventArgLowerAt(isAt ? 6 : 5));
    }

    @Override
    public String getName() {
        return "PlayerRightClicksEntity";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), this.entity.isNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("click_position") && this.event instanceof PlayerInteractAtEntityEvent) {
            return new LocationTag(((PlayerInteractAtEntityEvent)this.event).getClickedPosition());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerRightClicksAtEntity(PlayerInteractAtEntityEvent event) {
        this.playerRightClicksEntityHandler((PlayerInteractEntityEvent)event);
    }

    @EventHandler
    public void playerRightClicksEntity(PlayerInteractEntityEvent event) {
        if (event instanceof PlayerInteractAtEntityEvent) {
            return;
        }
        this.playerRightClicksEntityHandler(event);
    }

    public void playerRightClicksEntityHandler(PlayerInteractEntityEvent event) {
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        this.entity = new EntityTag(event.getRightClicked());
        this.item = new ItemTag(event.getPlayer().getItemInHand());
        this.location = new LocationTag(event.getRightClicked().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

