/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class PlayerThrowsEggScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerThrowsEggScriptEvent instance;
    public EntityTag egg;
    public Boolean is_hatching;
    private EntityType type;
    public PlayerEggThrowEvent event;

    public PlayerThrowsEggScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player throws") && lower.contains("egg");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("hatching") && !this.is_hatching.booleanValue()) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("non-hatching") && this.is_hatching.booleanValue()) {
            return false;
        }
        return this.runInCheck(path, this.egg.getLocation());
    }

    @Override
    public String getName() {
        return "PlayerThrowsEgg";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (EntityTag.matches(determination)) {
            this.is_hatching = true;
            this.type = EntityTag.valueOf(determination).getBukkitEntityType();
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag(this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("is_hatching")) {
            return new ElementTag(this.is_hatching);
        }
        if (name.equals("egg")) {
            return this.egg;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerThrowsEgg(PlayerEggThrowEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Debug.log("Is this even firing?");
        this.is_hatching = event.isHatching();
        Egg eggEntity = event.getEgg();
        EntityTag.rememberEntity((Entity)eggEntity);
        this.egg = new EntityTag((Entity)event.getEgg());
        this.type = event.getHatchingType();
        this.event = event;
        this.cancelled = false;
        this.fire((Event)event);
        if (this.cancelled) {
            this.is_hatching = false;
        }
        EntityTag.forgetEntity((Entity)eggEntity);
        event.setHatching(this.is_hatching.booleanValue());
        event.setHatchingType(this.type);
    }
}

