/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.material.MaterialAge;
import com.denizenscript.denizen.objects.properties.material.MaterialDirectional;
import com.denizenscript.denizen.objects.properties.material.MaterialHalf;
import com.denizenscript.denizen.objects.properties.material.MaterialLeaves;
import com.denizenscript.denizen.objects.properties.material.MaterialLevel;
import com.denizenscript.denizen.objects.properties.material.MaterialLightable;
import com.denizenscript.denizen.objects.properties.material.MaterialSlab;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.blocks.ModernBlockData;
import com.denizenscript.denizen.utilities.blocks.OldMaterialsHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.material.MaterialData;

public class MaterialTag
implements ObjectTag,
Adjustable {
    private String forcedIdentity = null;
    private String forcedIdentityLow = null;
    public static TagContext noDebugContext = new BukkitTagContext(null, null, false, null, false, null);
    private Material material;
    private Byte data = 0;
    private ModernBlockData modernData;
    String prefix = "material";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public MaterialTag forceIdentifyAs(String string) {
        this.forcedIdentity = string;
        this.forcedIdentityLow = CoreUtilities.toLowerCase(string);
        return this;
    }

    public static MaterialTag valueOf(String string) {
        return MaterialTag.valueOf(string, null);
    }

    @Fetchable(value="m")
    public static MaterialTag valueOf(String string, TagContext context) {
        MaterialTag mat;
        Material m;
        if (ObjectFetcher.DESCRIBED_PATTERN.matcher(string).matches()) {
            return ObjectFetcher.getObjectFrom(MaterialTag.class, string, context);
        }
        if ((string = string.toUpperCase()).startsWith("M@")) {
            string = string.substring("M@".length());
        }
        if (string.equals("RANDOM")) {
            return OldMaterialsHelper.getMaterialFrom(Material.values()[CoreUtilities.getRandom().nextInt(Material.values().length)]);
        }
        int index = string.indexOf(44);
        if (index < 0) {
            index = string.indexOf(58);
        }
        int data = 0;
        if (index >= 0) {
            data = ArgumentHelper.getIntegerFrom(string.substring(index + 1));
            string = string.substring(0, index);
        }
        if ((m = Material.getMaterial((String)string)) == null && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && (m = Material.getMaterial((String)string, (boolean)true)) != null) {
            m = Bukkit.getUnsafe().fromLegacy(m);
            if (context == null || context.debug) {
                Debug.log("'" + string + "' is a legacy (pre-1.13) material name. It is now '" + m.name() + "'.");
            }
        }
        if (m != null) {
            if (index >= 0) {
                if (context != noDebugContext && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    Deprecations.materialIdsSuggestProperties.warn(context);
                }
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                return new MaterialTag(m);
            }
            return OldMaterialsHelper.getMaterialFrom(m, data);
        }
        if (OldMaterialsHelper.all_dMaterials != null && (mat = OldMaterialsHelper.all_dMaterials.get(string)) != null) {
            if (index >= 0 && context != noDebugContext && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                Deprecations.materialIdsSuggestProperties.warn(context);
            }
            if (data == 0) {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    return new MaterialTag(mat.material);
                }
                return mat;
            }
            return OldMaterialsHelper.getMaterialFrom(mat.material, data);
        }
        int matid = ArgumentHelper.getIntegerFrom(string);
        if (matid != 0) {
            if (context != noDebugContext) {
                Deprecations.materialIdsSuggestNames.warn(context);
            }
            if ((m = OldMaterialsHelper.getLegacyMaterial(matid)) != null) {
                return OldMaterialsHelper.getMaterialFrom(m, data);
            }
        }
        return null;
    }

    public static MaterialTag quickOfNamed(String string) {
        Material m;
        int index = (string = string.toUpperCase()).indexOf(44);
        if (index < 0) {
            index = string.indexOf(58);
        }
        int data = 0;
        if (index >= 0) {
            data = ArgumentHelper.getIntegerFrom(string.substring(index + 1));
            string = string.substring(0, index);
        }
        if ((m = Material.getMaterial((String)string)) != null) {
            return OldMaterialsHelper.getMaterialFrom(m, data);
        }
        MaterialTag mat = OldMaterialsHelper.all_dMaterials.get(string);
        if (mat != null) {
            if (data == 0) {
                return mat;
            }
            return OldMaterialsHelper.getMaterialFrom(mat.material, data);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return MaterialTag.valueOf(arg, noDebugContext) != null;
    }

    public boolean equals(Object object) {
        if (object instanceof MaterialTag) {
            return this.getMaterial() == ((MaterialTag)object).getMaterial() && this.getData((byte)0) == ((MaterialTag)object).getData((byte)0);
        }
        MaterialTag parsed = MaterialTag.valueOf(object.toString());
        return this.equals(parsed);
    }

    public boolean matchesBlock(Block b) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            return this.getMaterial() == b.getType();
        }
        return this.matchesMaterialData(b.getType().getNewData(b.getData()));
    }

    public MaterialTag(Material material, int data) {
        this.material = material;
        this.data = data < 0 ? null : Byte.valueOf((byte)data);
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && material.isBlock()) {
            this.modernData = new ModernBlockData(material);
        }
    }

    public MaterialTag(Material material) {
        this(material, 0);
    }

    public MaterialTag(BlockState state) {
        this.material = state.getType();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            this.modernData = new ModernBlockData(state);
        } else {
            this.data = state.getRawData();
        }
    }

    public MaterialTag(BlockData block) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            this.modernData = block.modern();
            this.material = this.modernData.getMaterial();
        } else {
            this.material = block.getMaterial();
            this.data = block.getData();
        }
    }

    public MaterialTag(Block block) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            this.modernData = new ModernBlockData(block);
            this.material = this.modernData.getMaterial();
        } else {
            this.material = block.getType();
            this.data = block.getData();
        }
    }

    public MaterialTag(ModernBlockData data) {
        this.modernData = data;
        this.material = data.getMaterial();
    }

    public boolean hasModernData() {
        return this.modernData != null;
    }

    public ModernBlockData getModernData() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            return this.modernData;
        }
        throw new IllegalStateException("Modern block data handler is not available prior to MC 1.13.");
    }

    public void setModernData(ModernBlockData data) {
        this.modernData = data;
    }

    public Material getMaterial() {
        return this.material;
    }

    public BlockData getNmsBlockData() {
        if (this.modernData != null) {
            return NMSHandler.getBlockHelper().getBlockData(this.modernData);
        }
        return NMSHandler.getBlockHelper().getBlockData(this.getMaterial(), this.getData((byte)0));
    }

    public String name() {
        return this.material.name();
    }

    public byte getData(byte fallback) {
        if (this.data == null) {
            return fallback;
        }
        return this.data;
    }

    public Byte getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean matchesMaterialData(MaterialData data) {
        if (this.hasData()) {
            return this.material == data.getItemType() && this.data.byteValue() == data.getData();
        }
        return this.material == data.getItemType();
    }

    public MaterialData getMaterialData() {
        return new MaterialData(this.material, this.data != null ? this.data : (byte)0);
    }

    public boolean isStructure() {
        if (this.material == Material.CHORUS_PLANT) {
            return true;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && (this.material == Material.RED_MUSHROOM_BLOCK || this.material == Material.BROWN_MUSHROOM_BLOCK)) {
            return true;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12)) {
            if (this.material == Material.RED_MUSHROOM || this.material == Material.BROWN_MUSHROOM) {
                return true;
            }
            String name = this.material.name();
            return name.equals("SAPLING") || name.equals("HUGE_MUSHROOM_1") || name.equals("HUGE_MUSHROOM_2");
        }
        return false;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Material";
    }

    @Override
    public String identify() {
        return "m@" + this.identifyNoIdentifier();
    }

    public String identifyFull() {
        return "m@" + this.identifyFullNoIdentifier();
    }

    @Override
    public String identifySimple() {
        return "m@" + this.identifySimpleNoIdentifier();
    }

    public String identifyNoPropertiesNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    public String identifyNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name()) + PropertyParser.getPropertiesString(this);
    }

    public String identifySimpleNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    public String identifyFullNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow + (this.getData() != null ? "," + this.getData() : "");
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name()) + PropertyParser.getPropertiesString(this);
    }

    public String toString() {
        return this.identify();
    }

    public String realName() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        MaterialTag.registerTag("id", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                Deprecations.materialIdsSuggestNames.warn(attribute.getScriptEntry());
                return new ElementTag(((MaterialTag)object).material.getId()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("data", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if (attribute.context == null || attribute.context.debug) {
                    Deprecations.materialIdsSuggestProperties.warn(attribute.getScriptEntry());
                }
                return new ElementTag(((MaterialTag)object).getData()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_ageable", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(MaterialAge.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_plant", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(MaterialAge.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_directional", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(MaterialDirectional.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_bisected", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(MaterialHalf.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_leaves", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(MaterialLeaves.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_slab", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(MaterialSlab.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_levelable", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(MaterialLevel.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_lightable", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(MaterialLightable.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("has_gravity", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.hasGravity()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_block", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.isBlock()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_burnable", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.isBurnable()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_edible", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.isEdible()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_flammable", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.isFlammable()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_occluding", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.isOccluding()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_record", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.isRecord()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_solid", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.isSolid()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_transparent", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.isTransparent()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("max_durability", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.getMaxDurability()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("block_resistance", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                MaterialTag material = (MaterialTag)object;
                if (!NMSHandler.getBlockHelper().hasBlock(material.getMaterial())) {
                    Debug.echoError("Provided material does not have a placeable block.");
                    return null;
                }
                return new ElementTag(NMSHandler.getBlockHelper().getBlockResistance(material.getMaterial())).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("hardness", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                MaterialTag material = (MaterialTag)object;
                if (!material.getMaterial().isBlock()) {
                    Debug.echoError("Provided material does not have a placeable block.");
                    return null;
                }
                return new ElementTag(material.getMaterial().getHardness()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("max_stack_size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.getMaxStackSize()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("is_made_of", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                MaterialTag compared = MaterialTag.valueOf(attribute.getContext(1));
                return new ElementTag(compared != null && ((MaterialTag)object).material == compared.getMaterial()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("bukkit_enum", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).material.name()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((MaterialTag)object).forcedIdentity != null ? ((MaterialTag)object).forcedIdentityLow : CoreUtilities.toLowerCase(((MaterialTag)object).material.name())).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("full", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if (((MaterialTag)object).hasData()) {
                    return new ElementTag(((MaterialTag)object).identifyFull()).getAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((MaterialTag)object).identify()).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("item", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                MaterialTag material = (MaterialTag)object;
                ItemTag item = new ItemTag(material, 1);
                attribute = attribute.fulfill(1);
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                    if (!attribute.isComplete()) {
                        String tag = attribute.getAttribute(1);
                        String returned = CoreUtilities.autoPropertyTag(object, attribute);
                        if (returned != null) {
                            Debug.echoError("Usage of outdated 'material.item." + tag + "' tag should be replaced by 'material." + tag + "' (with '.item' removed).");
                            return returned;
                        }
                    }
                    if (item.getItemStack().hasItemMeta() && item.getItemStack().getItemMeta() instanceof BlockStateMeta) {
                        ((BlockStateMeta)item.getItemStack().getItemMeta()).setBlockState(material.modernData.getBlockState());
                    }
                }
                return item.getAttribute(attribute);
            }
        });
        MaterialTag.registerTag("piston_reaction", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                String res = NMSHandler.getBlockHelper().getPushReaction(((MaterialTag)object).material);
                if (res == null) {
                    return null;
                }
                return new ElementTag(res).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("block_strength", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                float res = NMSHandler.getBlockHelper().getBlockStength(((MaterialTag)object).material);
                return new ElementTag(res).getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Material").getAttribute(attribute.fulfill(1));
            }
        });
        MaterialTag.registerTag("with", new TagRunnable(){

            @Override
            public String run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("MaterialTag.with[...] tag must have an input mechanism list.");
                }
                MaterialTag mat = new MaterialTag(((MaterialTag)object).getModernData().clone());
                List<String> properties = ObjectFetcher.separateProperties("[" + attribute.getContext(1) + "]");
                for (int i = 1; i < properties.size(); ++i) {
                    List<String> data = CoreUtilities.split(properties.get(i), '=', 2);
                    if (data.size() != 2) {
                        Debug.echoError("Invalid property string '" + properties.get(i) + "'!");
                        continue;
                    }
                    mat.safeApplyProperty(new Mechanism(new ElementTag(data.get(0)), new ElementTag(data.get(1).replace('\u2011', ';')), attribute.context));
                }
                return mat.getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                com.denizenscript.denizencore.utilities.debugging.Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new ElementTag(this.identify()).getAttribute(attribute.fulfill(0));
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (!mechanism.isProperty && mechanism.matches("block_resistance") && mechanism.requireFloat() && !NMSHandler.getBlockHelper().setBlockResistance(this.material, mechanism.getValue().asFloat())) {
            Debug.echoError("Provided material does not have a placeable block.");
        }
        if (!mechanism.isProperty && mechanism.matches("block_strength") && mechanism.requireFloat()) {
            if (!this.material.isBlock()) {
                Debug.echoError("'block_strength' mechanism is only valid for block types.");
            }
            NMSHandler.getBlockHelper().setBlockStrength(this.material, mechanism.getValue().asFloat());
        }
        if (!mechanism.isProperty && mechanism.matches("piston_reaction")) {
            if (!this.material.isBlock()) {
                Debug.echoError("'piston_reaction' mechanism is only valid for block types.");
            }
            NMSHandler.getBlockHelper().setPushReaction(this.material, mechanism.getValue().asString().toUpperCase());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

