/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.bukkit.ChatColor;

public class BukkitElementProperties
implements Property {
    public static final String[] handledTags = new String[]{"aschunk", "as_chunk", "ascolor", "as_color", "ascuboid", "as_cuboid", "asentity", "as_entity", "asinventory", "as_inventory", "asitem", "as_item", "aslocation", "as_location", "asmaterial", "as_material", "asnpc", "as_npc", "asplayer", "as_player", "asworld", "as_world", "asplugin", "as_plugin", "last_color", "format", "strip_color", "parse_color", "to_itemscript_hash", "to_secret_colors", "from_secret_colors"};
    public static final String[] handledMechs = new String[0];
    ElementTag element;

    public static boolean describes(ObjectTag element) {
        return element instanceof ElementTag;
    }

    public static BukkitElementProperties getFrom(ObjectTag element) {
        if (!BukkitElementProperties.describes(element)) {
            return null;
        }
        return new BukkitElementProperties((ElementTag)element);
    }

    private BukkitElementProperties(ElementTag element) {
        this.element = element;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        String text;
        ObjectTag object;
        if ((attribute.startsWith("aschunk") || attribute.startsWith("as_chunk")) && (object = ElementTag.handleNull(this.element.asString(), ChunkTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dChunk", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("ascolor") || attribute.startsWith("as_color")) && (object = ElementTag.handleNull(this.element.asString(), ColorTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dColor", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("ascuboid") || attribute.startsWith("as_cuboid")) && (object = ElementTag.handleNull(this.element.asString(), CuboidTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dCuboid", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("asentity") || attribute.startsWith("as_entity")) && (object = ElementTag.handleNull(this.element.asString(), EntityTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dEntity", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("asinventory") || attribute.startsWith("as_inventory")) && (object = ElementTag.handleNull(this.element.asString(), InventoryTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dInventory", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("asitem") || attribute.startsWith("as_item")) && (object = ElementTag.handleNull(this.element.asString(), ItemTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dItem", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("aslocation") || attribute.startsWith("as_location")) && (object = ElementTag.handleNull(this.element.asString(), LocationTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dLocation", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("asmaterial") || attribute.startsWith("as_material")) && (object = ElementTag.handleNull(this.element.asString(), MaterialTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dMaterial", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("asnpc") || attribute.startsWith("as_npc")) && (object = ElementTag.handleNull(this.element.asString(), NPCTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dNPC", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("asplayer") || attribute.startsWith("as_player")) && (object = ElementTag.handleNull(this.element.asString(), PlayerTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dPlayer", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("asworld") || attribute.startsWith("as_world")) && (object = ElementTag.handleNull(this.element.asString(), WorldTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dWorld", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("asplugin") || attribute.startsWith("as_plugin")) && (object = ElementTag.handleNull(this.element.asString(), PluginTag.valueOf(this.element.asString(), new BukkitTagContext(attribute.getScriptEntry(), false)), "dPlugin", attribute.hasAlternative())) != null) {
            return object.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_color")) {
            return new ElementTag(ChatColor.getLastColors((String)this.element.asString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("format") && attribute.hasContext(1)) {
            FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(attribute.getContext(1));
            if (format == null) {
                Debug.echoError("Could not find format script matching '" + attribute.getContext(1) + "'");
                return null;
            }
            return new ElementTag(format.getFormattedText(this.element.asString(), attribute.getScriptEntry() != null ? ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getNPC() : null, attribute.getScriptEntry() != null ? ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getPlayer() : null)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("strip_color")) {
            return new ElementTag(ChatColor.stripColor((String)this.element.asString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("parse_color")) {
            char prefix = '&';
            if (attribute.hasContext(1)) {
                prefix = attribute.getContext(1).charAt(0);
            }
            return new ElementTag(ChatColor.translateAlternateColorCodes((char)prefix, (String)this.element.asString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("to_itemscript_hash")) {
            return new ElementTag(ItemScriptHelper.createItemScriptID(this.element.asString())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("to_secret_colors")) {
            text = this.element.asString();
            byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
            String hex = DatatypeConverter.printHexBinary((byte[])bytes);
            StringBuilder colors = new StringBuilder(text.length() * 2);
            for (int i = 0; i < hex.length(); ++i) {
                colors.append('\u00a7').append(hex.charAt(i));
            }
            return new ElementTag(colors.toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("from_secret_colors")) {
            text = this.element.asString().replace(String.valueOf('\u00a7'), "");
            byte[] bytes = DatatypeConverter.parseHexBinary((String)text);
            return new ElementTag(new String(bytes, StandardCharsets.UTF_8)).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "BukkitElementProperties";
    }

    @Override
    public void adjust(Mechanism mechanism) {
    }
}

