/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;

public class EntityInfected
implements Property {
    public static final String[] handledTags = new String[]{"is_infected"};
    public static final String[] handledMechs = new String[]{"is_infected"};
    EntityTag infected;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).getBukkitEntityType() == EntityType.ZOMBIE || ((EntityTag)entity).getBukkitEntityType() == EntityType.VILLAGER;
    }

    public static EntityInfected getFrom(ObjectTag entity) {
        if (!EntityInfected.describes(entity)) {
            return null;
        }
        return new EntityInfected((EntityTag)entity);
    }

    private EntityInfected(EntityTag item) {
        this.infected = item;
    }

    public boolean isInfected() {
        return this.infected.getBukkitEntity() instanceof Zombie && this.infected.getBukkitEntityType() == EntityType.ZOMBIE_VILLAGER;
    }

    public void setInfected(boolean bool) {
        if (bool) {
            if (this.infected.isCitizensNPC()) {
                NPC infected_npc = this.infected.getDenizenNPC().getCitizen();
                infected_npc.setBukkitEntityType(EntityType.ZOMBIE_VILLAGER);
            }
            LivingEntity entity = this.infected.getLivingEntity();
            ZombieVillager infect = (ZombieVillager)entity.getLocation().getWorld().spawnEntity((Location)this.infected.getLocation(), EntityType.ZOMBIE_VILLAGER);
            infect.setHealth(entity.getHealth());
            infect.getEquipment().setArmorContents(entity.getEquipment().getArmorContents());
            entity.remove();
            this.infected.setEntity((Entity)infect);
        }
    }

    @Override
    public String getPropertyString() {
        if (this.isInfected()) {
            return "true";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "infected";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_infected")) {
            Debug.echoError("Different infection types are represented by different entity types. Please remove usage of the 'is_infected' tag.");
            return new ElementTag(this.isInfected()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("is_infected") && mechanism.requireBoolean()) {
            Debug.echoError("Different infection types are represented by different entity types. Please remove usage of the 'is_infected' mechanism.");
            this.setInfected(mechanism.getValue().asBoolean());
        }
    }
}

