/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;

public class EntityPotion
implements Property {
    public static final String[] handledTags = new String[]{"potion"};
    public static final String[] handledMechs = new String[]{"potion"};
    EntityTag potion;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).getBukkitEntityType() == EntityType.SPLASH_POTION;
    }

    public static EntityPotion getFrom(ObjectTag entity) {
        if (!EntityPotion.describes(entity)) {
            return null;
        }
        return new EntityPotion((EntityTag)entity);
    }

    private EntityPotion(EntityTag entity) {
        this.potion = entity;
    }

    private ThrownPotion getPotion() {
        if (this.potion == null) {
            return null;
        }
        return (ThrownPotion)this.potion.getBukkitEntity();
    }

    public void setPotion(ItemStack item) {
        if (this.potion != null) {
            ((ThrownPotion)this.potion.getBukkitEntity()).setItem(item);
        }
    }

    @Override
    public String getPropertyString() {
        if (this.potion == null) {
            return null;
        }
        return new ItemTag(this.getPotion().getItem()).identify();
    }

    @Override
    public String getPropertyId() {
        return "potion";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("potion")) {
            return new ItemTag(this.getPotion().getItem()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion") && mechanism.requireObject(ItemTag.class)) {
            this.setPotion(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
    }
}

