/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;

public class EntityRotation
implements Property {
    public static final String[] handledTags = new String[]{"rotation"};
    public static final String[] handledMechs = new String[]{"rotation"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).getBukkitEntityType() == EntityType.PAINTING || ((EntityTag)entity).getBukkitEntityType() == EntityType.ITEM_FRAME;
    }

    public static EntityRotation getFrom(ObjectTag entity) {
        if (!EntityRotation.describes(entity)) {
            return null;
        }
        return new EntityRotation((EntityTag)entity);
    }

    private EntityRotation(EntityTag entity) {
        this.entity = entity;
    }

    private BlockFace getRotation() {
        return ((Hanging)this.entity.getBukkitEntity()).getAttachedFace().getOppositeFace();
    }

    public void setRotation(BlockFace direction) {
        ((Hanging)this.entity.getBukkitEntity()).setFacingDirection(direction, true);
    }

    @Override
    public String getPropertyString() {
        return CoreUtilities.toLowerCase(this.getRotation().name());
    }

    @Override
    public String getPropertyId() {
        return "rotation";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("rotation_vector")) {
            return new LocationTag(this.getRotation().getDirection()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("rotation")) {
            return new ElementTag(CoreUtilities.toLowerCase(this.getRotation().name())).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("rotation") && mechanism.requireEnum(false, (Enum<?>[])BlockFace.values())) {
            this.setRotation(BlockFace.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
    }
}

