/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;

public class CooldownCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        scriptEntry.addObject("type", (Object)Type.PLAYER);
        scriptEntry.addObject("script", scriptEntry.getScript());
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!arg.hasPrefix() && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matchesPrefix("script", "s")) {
                if (arg.matchesArgumentType(ScriptTag.class)) {
                    scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                    continue;
                }
                throw new InvalidArgumentsException("Specified an invalid script!");
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("duration")) {
            throw new InvalidArgumentsException("Requires a valid duration!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Type type;
        ScriptTag script = (ScriptTag)scriptEntry.getObject("script");
        DurationTag duration = (DurationTag)scriptEntry.getObject("duration");
        Type type2 = type = scriptEntry.hasObject("type") ? (Type)((Object)scriptEntry.getObject("type")) : Type.PLAYER;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("Type", type.name()) + script.debug() + (type.name().equalsIgnoreCase("player") ? Utilities.getEntryPlayer(scriptEntry).debug() : "") + duration.debug());
        }
        switch (type) {
            case PLAYER: {
                CooldownCommand.setCooldown(Utilities.getEntryPlayer(scriptEntry), duration, script.getName(), false);
                break;
            }
            case GLOBAL: {
                CooldownCommand.setCooldown(null, duration, script.getName(), true);
            }
        }
    }

    public static DurationTag getCooldownDuration(PlayerTag player, String scriptName) {
        DurationTag player_dur;
        scriptName = scriptName.toUpperCase();
        DurationTag duration = DurationTag.ZERO;
        if (DenizenAPI.getSaves().contains("Global.Scripts." + scriptName + ".Cooldown Time") && System.currentTimeMillis() < DenizenAPI.getSaves().getLong("Global.Scripts." + scriptName + ".Cooldown Time")) {
            duration = new DurationTag((double)(DenizenAPI.getSaves().getLong("Global.Scripts." + scriptName + ".Cooldown Time") - System.currentTimeMillis()) / 1000.0);
        }
        if (player == null) {
            return duration;
        }
        if (!DenizenAPI.getSaves().contains("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time")) {
            return duration;
        }
        if (System.currentTimeMillis() <= DenizenAPI.getSaves().getLong("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time") && (player_dur = new DurationTag((double)(DenizenAPI.getSaves().getLong("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time") - System.currentTimeMillis()) / 1000.0)).getSeconds() > duration.getSeconds()) {
            return player_dur;
        }
        return duration;
    }

    public static boolean checkCooldown(PlayerTag player, String scriptName) {
        scriptName = scriptName.toUpperCase();
        if (DenizenAPI.getSaves().contains("Global.Scripts." + scriptName + ".Cooldown Time")) {
            if (System.currentTimeMillis() < DenizenAPI.getSaves().getLong("Global.Scripts." + scriptName + ".Cooldown Time")) {
                return false;
            }
            DenizenAPI.getSaves().set("Global.Scripts." + scriptName + ".Cooldown Time", null);
        }
        if (player == null) {
            return true;
        }
        if (!DenizenAPI.getSaves().contains("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time")) {
            return true;
        }
        if (System.currentTimeMillis() >= DenizenAPI.getSaves().getLong("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time")) {
            DenizenAPI.getSaves().set("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time", null);
            return true;
        }
        return false;
    }

    public static void setCooldown(PlayerTag player, DurationTag duration, String scriptName, boolean global) {
        scriptName = scriptName.toUpperCase();
        if (global) {
            DenizenAPI.getSaves().set("Global.Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration.getSecondsAsInt() * 1000)));
        } else {
            DenizenAPI.getSaves().set("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration.getSecondsAsInt() * 1000)));
        }
    }

    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

