/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.MaterialCompat;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LeashHitch;

public class LeashCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel", "stop")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("holder") && arg.matchesPrefix("holder", "h")) {
                if (arg.matchesArgumentType(EntityTag.class)) {
                    scriptEntry.addObject("holder", arg.asType(EntityTag.class));
                    continue;
                }
                if (!arg.matchesArgumentType(LocationTag.class)) continue;
                scriptEntry.addObject("holder", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("cancel")) {
            scriptEntry.defaultObject("holder", Utilities.entryHasNPC(scriptEntry) ? Utilities.getEntryNPC(scriptEntry).getDenizenEntity() : null, Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getDenizenEntity() : null);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        EntityTag holder = null;
        LocationTag holderLoc = null;
        Entity Holder2 = null;
        Object holderObject = scriptEntry.getObject("holder");
        if (holderObject instanceof EntityTag) {
            holder = (EntityTag)scriptEntry.getObject("holder");
            Holder2 = holder.getBukkitEntity();
        } else if (holderObject instanceof LocationTag) {
            holderLoc = (LocationTag)scriptEntry.getObject("holder");
            Material material = holderLoc.getBlock().getType();
            if (material == MaterialCompat.OAK_FENCE || material == MaterialCompat.NETHER_FENCE || material == Material.ACACIA_FENCE || material == Material.BIRCH_FENCE || material == Material.JUNGLE_FENCE || material == Material.DARK_OAK_FENCE || material == Material.SPRUCE_FENCE) {
                Holder2 = holderLoc.getWorld().spawn((Location)holderLoc, LeashHitch.class);
            } else {
                Debug.echoError(scriptEntry.getResidingQueue(), "Bad holder location specified - only fences are permitted!");
                return;
            }
        }
        Boolean cancel = scriptEntry.hasObject("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (cancel != false ? ArgumentHelper.debugObj("cancel", cancel) : "") + ArgumentHelper.debugObj("entities", entities.toString()) + (holder != null ? ArgumentHelper.debugObj("holder", holder) : ArgumentHelper.debugObj("holder", holderLoc)));
        }
        for (EntityTag entity : entities) {
            if (!entity.isSpawned() || !entity.isLivingEntity()) continue;
            if (cancel.booleanValue()) {
                entity.getLivingEntity().setLeashHolder(null);
                continue;
            }
            entity.getLivingEntity().setLeashHolder(Holder2);
        }
    }
}

