/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.Settings;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;

public class BukkitWorldScriptHelper
implements Listener {
    private final Map<String, Integer> current_time = new HashMap<String, Integer>();

    public BukkitWorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static String doEvents(List<String> events, NPCTag npc, PlayerTag player, Map<String, ObjectTag> context) {
        return BukkitWorldScriptHelper.doEvents(events, npc, player, context, false);
    }

    public static String doEvents(List<String> events, NPCTag npc, PlayerTag player, Map<String, ObjectTag> context, boolean useids) {
        List<String> determ = useids ? OldEventManager.doEvents(events, new BukkitScriptEntryData(player, npc), context, true) : OldEventManager.doEvents(events, new BukkitScriptEntryData(player, npc), context);
        return determ.size() > 0 ? determ.get(0) : "none";
    }

    public void serverStartEvent() {
        long ticks = Settings.worldScriptTimeEventFrequency().getTicks();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                BukkitWorldScriptHelper.this.timeEvent();
            }
        }, ticks, ticks);
        BukkitWorldScriptHelper.doEvents(Arrays.asList("server start"), null, null, null);
    }

    public void serverPreStartEvent() {
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("server prestart"), null, null, null);
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            WorldTag currentWorld;
            int hour = Double.valueOf(world.getTime() / 1000L).intValue();
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey((currentWorld = new WorldTag(world)).identifySimple()) && this.current_time.get(currentWorld.identifySimple()) == hour) continue;
            HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
            context.put("time", new ElementTag(hour));
            context.put("world", currentWorld);
            BukkitWorldScriptHelper.doEvents(Arrays.asList("time changes", "time changes in " + currentWorld.identifySimple(), String.valueOf(hour) + ":00 in " + currentWorld.identifySimple(), "time " + String.valueOf(hour) + " in " + currentWorld.identifySimple()), null, null, context, true);
            this.current_time.put(currentWorld.identifySimple(), hour);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoins(PlayerJoinEvent event) {
        Scoreboard score;
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (ScoreboardHelper.viewerMap.containsKey(event.getPlayer().getName()) && (score = ScoreboardHelper.getScoreboard(ScoreboardHelper.viewerMap.get(event.getPlayer().getName()))) != null) {
            event.getPlayer().setScoreboard(score);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final String message = ChatColor.DARK_GREEN + "CHAT: " + event.getPlayer().getName() + ": " + event.getMessage();
        Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                if (Debug.record) {
                    Debug.log(message);
                }
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerLogin(PlayerLoginEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        PlayerTag.notePlayer((OfflinePlayer)event.getPlayer());
    }
}

